/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the status and settings of the APNs (Apple Push Notification service) channel for an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class APNSChannelRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<APNSChannelRequest.Builder, APNSChannelRequest> {
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BundleId").getter(getter(APNSChannelRequest::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()).build();

    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Certificate").getter(getter(APNSChannelRequest::certificate)).setter(setter(Builder::certificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final SdkField<String> DEFAULT_AUTHENTICATION_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultAuthenticationMethod")
            .getter(getter(APNSChannelRequest::defaultAuthenticationMethod))
            .setter(setter(Builder::defaultAuthenticationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAuthenticationMethod")
                    .build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(APNSChannelRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateKey").getter(getter(APNSChannelRequest::privateKey)).setter(setter(Builder::privateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKey").build()).build();

    private static final SdkField<String> TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TeamId")
            .getter(getter(APNSChannelRequest::teamId)).setter(setter(Builder::teamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamId").build()).build();

    private static final SdkField<String> TOKEN_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TokenKey").getter(getter(APNSChannelRequest::tokenKey)).setter(setter(Builder::tokenKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenKey").build()).build();

    private static final SdkField<String> TOKEN_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TokenKeyId").getter(getter(APNSChannelRequest::tokenKeyId)).setter(setter(Builder::tokenKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_ID_FIELD,
            CERTIFICATE_FIELD, DEFAULT_AUTHENTICATION_METHOD_FIELD, ENABLED_FIELD, PRIVATE_KEY_FIELD, TEAM_ID_FIELD,
            TOKEN_KEY_FIELD, TOKEN_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bundleId;

    private final String certificate;

    private final String defaultAuthenticationMethod;

    private final Boolean enabled;

    private final String privateKey;

    private final String teamId;

    private final String tokenKey;

    private final String tokenKeyId;

    private APNSChannelRequest(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.certificate = builder.certificate;
        this.defaultAuthenticationMethod = builder.defaultAuthenticationMethod;
        this.enabled = builder.enabled;
        this.privateKey = builder.privateKey;
        this.teamId = builder.teamId;
        this.tokenKey = builder.tokenKey;
        this.tokenKeyId = builder.tokenKeyId;
    }

    /**
     * <p>
     * The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.
     * </p>
     * 
     * @return The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.
     */
    public final String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with APNs by
     * using an APNs certificate.
     * </p>
     * 
     * @return The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with
     *         APNs by using an APNs certificate.
     */
    public final String certificate() {
        return certificate;
    }

    /**
     * <p>
     * The default authentication method that you want Amazon Pinpoint to use when authenticating with APNs, key or
     * certificate.
     * </p>
     * 
     * @return The default authentication method that you want Amazon Pinpoint to use when authenticating with APNs, key
     *         or certificate.
     */
    public final String defaultAuthenticationMethod() {
        return defaultAuthenticationMethod;
    }

    /**
     * <p>
     * Specifies whether to enable the APNs channel for the application.
     * </p>
     * 
     * @return Specifies whether to enable the APNs channel for the application.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with APNs.
     * </p>
     * 
     * @return The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with
     *         APNs.
     */
    public final String privateKey() {
        return privateKey;
    }

    /**
     * <p>
     * The identifier that's assigned to your Apple developer account team. This identifier is used for APNs tokens.
     * </p>
     * 
     * @return The identifier that's assigned to your Apple developer account team. This identifier is used for APNs
     *         tokens.
     */
    public final String teamId() {
        return teamId;
    }

    /**
     * <p>
     * The authentication key to use for APNs tokens.
     * </p>
     * 
     * @return The authentication key to use for APNs tokens.
     */
    public final String tokenKey() {
        return tokenKey;
    }

    /**
     * <p>
     * The key identifier that's assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with APNs
     * by using APNs tokens.
     * </p>
     * 
     * @return The key identifier that's assigned to your APNs signing key, if you want Amazon Pinpoint to communicate
     *         with APNs by using APNs tokens.
     */
    public final String tokenKeyId() {
        return tokenKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAuthenticationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(teamId());
        hashCode = 31 * hashCode + Objects.hashCode(tokenKey());
        hashCode = 31 * hashCode + Objects.hashCode(tokenKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APNSChannelRequest)) {
            return false;
        }
        APNSChannelRequest other = (APNSChannelRequest) obj;
        return Objects.equals(bundleId(), other.bundleId()) && Objects.equals(certificate(), other.certificate())
                && Objects.equals(defaultAuthenticationMethod(), other.defaultAuthenticationMethod())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(privateKey(), other.privateKey())
                && Objects.equals(teamId(), other.teamId()) && Objects.equals(tokenKey(), other.tokenKey())
                && Objects.equals(tokenKeyId(), other.tokenKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("APNSChannelRequest").add("BundleId", bundleId()).add("Certificate", certificate())
                .add("DefaultAuthenticationMethod", defaultAuthenticationMethod()).add("Enabled", enabled())
                .add("PrivateKey", privateKey()).add("TeamId", teamId()).add("TokenKey", tokenKey())
                .add("TokenKeyId", tokenKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "DefaultAuthenticationMethod":
            return Optional.ofNullable(clazz.cast(defaultAuthenticationMethod()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "PrivateKey":
            return Optional.ofNullable(clazz.cast(privateKey()));
        case "TeamId":
            return Optional.ofNullable(clazz.cast(teamId()));
        case "TokenKey":
            return Optional.ofNullable(clazz.cast(tokenKey()));
        case "TokenKeyId":
            return Optional.ofNullable(clazz.cast(tokenKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<APNSChannelRequest, T> g) {
        return obj -> g.apply((APNSChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, APNSChannelRequest> {
        /**
         * <p>
         * The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.
         * </p>
         * 
         * @param bundleId
         *        The bundle identifier that's assigned to your iOS app. This identifier is used for APNs tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with
         * APNs by using an APNs certificate.
         * </p>
         * 
         * @param certificate
         *        The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate
         *        with APNs by using an APNs certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(String certificate);

        /**
         * <p>
         * The default authentication method that you want Amazon Pinpoint to use when authenticating with APNs, key or
         * certificate.
         * </p>
         * 
         * @param defaultAuthenticationMethod
         *        The default authentication method that you want Amazon Pinpoint to use when authenticating with APNs,
         *        key or certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAuthenticationMethod(String defaultAuthenticationMethod);

        /**
         * <p>
         * Specifies whether to enable the APNs channel for the application.
         * </p>
         * 
         * @param enabled
         *        Specifies whether to enable the APNs channel for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with
         * APNs.
         * </p>
         * 
         * @param privateKey
         *        The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate
         *        with APNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKey(String privateKey);

        /**
         * <p>
         * The identifier that's assigned to your Apple developer account team. This identifier is used for APNs tokens.
         * </p>
         * 
         * @param teamId
         *        The identifier that's assigned to your Apple developer account team. This identifier is used for APNs
         *        tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamId(String teamId);

        /**
         * <p>
         * The authentication key to use for APNs tokens.
         * </p>
         * 
         * @param tokenKey
         *        The authentication key to use for APNs tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenKey(String tokenKey);

        /**
         * <p>
         * The key identifier that's assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with
         * APNs by using APNs tokens.
         * </p>
         * 
         * @param tokenKeyId
         *        The key identifier that's assigned to your APNs signing key, if you want Amazon Pinpoint to
         *        communicate with APNs by using APNs tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenKeyId(String tokenKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String bundleId;

        private String certificate;

        private String defaultAuthenticationMethod;

        private Boolean enabled;

        private String privateKey;

        private String teamId;

        private String tokenKey;

        private String tokenKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(APNSChannelRequest model) {
            bundleId(model.bundleId);
            certificate(model.certificate);
            defaultAuthenticationMethod(model.defaultAuthenticationMethod);
            enabled(model.enabled);
            privateKey(model.privateKey);
            teamId(model.teamId);
            tokenKey(model.tokenKey);
            tokenKeyId(model.tokenKeyId);
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        @Transient
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getCertificate() {
            return certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        @Transient
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getDefaultAuthenticationMethod() {
            return defaultAuthenticationMethod;
        }

        public final void setDefaultAuthenticationMethod(String defaultAuthenticationMethod) {
            this.defaultAuthenticationMethod = defaultAuthenticationMethod;
        }

        @Override
        @Transient
        public final Builder defaultAuthenticationMethod(String defaultAuthenticationMethod) {
            this.defaultAuthenticationMethod = defaultAuthenticationMethod;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getPrivateKey() {
            return privateKey;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        @Transient
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final String getTeamId() {
            return teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        @Transient
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final String getTokenKey() {
            return tokenKey;
        }

        public final void setTokenKey(String tokenKey) {
            this.tokenKey = tokenKey;
        }

        @Override
        @Transient
        public final Builder tokenKey(String tokenKey) {
            this.tokenKey = tokenKey;
            return this;
        }

        public final String getTokenKeyId() {
            return tokenKeyId;
        }

        public final void setTokenKeyId(String tokenKeyId) {
            this.tokenKeyId = tokenKeyId;
        }

        @Override
        @Transient
        public final Builder tokenKeyId(String tokenKeyId) {
            this.tokenKeyId = tokenKeyId;
            return this;
        }

        @Override
        public APNSChannelRequest build() {
            return new APNSChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
