/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the results of a query that retrieved the data for a standard metric that applies to an application,
 * campaign, or journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BaseKpiResult implements SdkPojo, Serializable, ToCopyableBuilder<BaseKpiResult.Builder, BaseKpiResult> {
    private static final SdkField<List<ResultRow>> ROWS_FIELD = SdkField
            .<List<ResultRow>> builder(MarshallingType.LIST)
            .memberName("Rows")
            .getter(getter(BaseKpiResult::rows))
            .setter(setter(Builder::rows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResultRow> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResultRow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROWS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ResultRow> rows;

    private BaseKpiResult(BuilderImpl builder) {
        this.rows = builder.rows;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rows property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRows() {
        return rows != null && !(rows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that provides the results of a query that retrieved the data for a standard metric that
     * applies to an application, campaign, or journey.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRows} method.
     * </p>
     * 
     * @return An array of objects that provides the results of a query that retrieved the data for a standard metric
     *         that applies to an application, campaign, or journey.
     */
    public final List<ResultRow> rows() {
        return rows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRows() ? rows() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseKpiResult)) {
            return false;
        }
        BaseKpiResult other = (BaseKpiResult) obj;
        return hasRows() == other.hasRows() && Objects.equals(rows(), other.rows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BaseKpiResult").add("Rows", hasRows() ? rows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rows":
            return Optional.ofNullable(clazz.cast(rows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BaseKpiResult, T> g) {
        return obj -> g.apply((BaseKpiResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BaseKpiResult> {
        /**
         * <p>
         * An array of objects that provides the results of a query that retrieved the data for a standard metric that
         * applies to an application, campaign, or journey.
         * </p>
         * 
         * @param rows
         *        An array of objects that provides the results of a query that retrieved the data for a standard metric
         *        that applies to an application, campaign, or journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Collection<ResultRow> rows);

        /**
         * <p>
         * An array of objects that provides the results of a query that retrieved the data for a standard metric that
         * applies to an application, campaign, or journey.
         * </p>
         * 
         * @param rows
         *        An array of objects that provides the results of a query that retrieved the data for a standard metric
         *        that applies to an application, campaign, or journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(ResultRow... rows);

        /**
         * <p>
         * An array of objects that provides the results of a query that retrieved the data for a standard metric that
         * applies to an application, campaign, or journey.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResultRow>.Builder} avoiding the need to
         * create one manually via {@link List<ResultRow>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResultRow>.Builder#build()} is called immediately and its
         * result is passed to {@link #rows(List<ResultRow>)}.
         * 
         * @param rows
         *        a consumer that will call methods on {@link List<ResultRow>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rows(List<ResultRow>)
         */
        Builder rows(Consumer<ResultRow.Builder>... rows);
    }

    static final class BuilderImpl implements Builder {
        private List<ResultRow> rows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BaseKpiResult model) {
            rows(model.rows);
        }

        public final List<ResultRow.Builder> getRows() {
            List<ResultRow.Builder> result = ListOfResultRowCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRows(Collection<ResultRow.BuilderImpl> rows) {
            this.rows = ListOfResultRowCopier.copyFromBuilder(rows);
        }

        @Override
        @Transient
        public final Builder rows(Collection<ResultRow> rows) {
            this.rows = ListOfResultRowCopier.copy(rows);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rows(ResultRow... rows) {
            rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rows(Consumer<ResultRow.Builder>... rows) {
            rows(Stream.of(rows).map(c -> ResultRow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BaseKpiResult build() {
            return new BaseKpiResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
