/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the status and settings of the email channel for an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailChannelRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailChannelRequest.Builder, EmailChannelRequest> {
    private static final SdkField<String> CONFIGURATION_SET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSet").getter(getter(EmailChannelRequest::configurationSet))
            .setter(setter(Builder::configurationSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSet").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(EmailChannelRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> FROM_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromAddress").getter(getter(EmailChannelRequest::fromAddress)).setter(setter(Builder::fromAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromAddress").build()).build();

    private static final SdkField<String> IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identity").getter(getter(EmailChannelRequest::identity)).setter(setter(Builder::identity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identity").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(EmailChannelRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_FIELD,
            ENABLED_FIELD, FROM_ADDRESS_FIELD, IDENTITY_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configurationSet;

    private final Boolean enabled;

    private final String fromAddress;

    private final String identity;

    private final String roleArn;

    private EmailChannelRequest(BuilderImpl builder) {
        this.configurationSet = builder.configurationSet;
        this.enabled = builder.enabled;
        this.fromAddress = builder.fromAddress;
        this.identity = builder.identity;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES
     * configuration set</a> that you want to apply to messages that you send through the channel.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES
     *         configuration set</a> that you want to apply to messages that you send through the channel.
     */
    public final String configurationSet() {
        return configurationSet;
    }

    /**
     * <p>
     * Specifies whether to enable the email channel for the application.
     * </p>
     * 
     * @return Specifies whether to enable the email channel for the application.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The verified email address that you want to send email from when you send email through the channel.
     * </p>
     * 
     * @return <p>
     *         The verified email address that you want to send email from when you send email through the channel.
     *         </p>
     */
    public final String fromAddress() {
        return fromAddress;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that you
     * want to use when you send email through the channel.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES),
     *         that you want to use when you send email through the channel.
     *         </p>
     */
    public final String identity() {
        return identity;
    }

    /**
     * <p>
     * The ARN of the AWS Identity and Access Management (IAM) role that you want Amazon Pinpoint to use when it submits
     * email-related event data for the channel.
     * </p>
     * 
     * @return <p>
     *         The ARN of the AWS Identity and Access Management (IAM) role that you want Amazon Pinpoint to use when it
     *         submits email-related event data for the channel.
     *         </p>
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationSet());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(fromAddress());
        hashCode = 31 * hashCode + Objects.hashCode(identity());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailChannelRequest)) {
            return false;
        }
        EmailChannelRequest other = (EmailChannelRequest) obj;
        return Objects.equals(configurationSet(), other.configurationSet()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(fromAddress(), other.fromAddress()) && Objects.equals(identity(), other.identity())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailChannelRequest").add("ConfigurationSet", configurationSet()).add("Enabled", enabled())
                .add("FromAddress", fromAddress()).add("Identity", identity()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSet":
            return Optional.ofNullable(clazz.cast(configurationSet()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "FromAddress":
            return Optional.ofNullable(clazz.cast(fromAddress()));
        case "Identity":
            return Optional.ofNullable(clazz.cast(identity()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailChannelRequest, T> g) {
        return obj -> g.apply((EmailChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailChannelRequest> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES
         * configuration set</a> that you want to apply to messages that you send through the channel.
         * </p>
         * 
         * @param configurationSet
         *        The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES
         *        configuration set</a> that you want to apply to messages that you send through the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSet(String configurationSet);

        /**
         * <p>
         * Specifies whether to enable the email channel for the application.
         * </p>
         * 
         * @param enabled
         *        Specifies whether to enable the email channel for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The verified email address that you want to send email from when you send email through the channel.
         * </p>
         * 
         * @param fromAddress
         *        <p>
         *        The verified email address that you want to send email from when you send email through the channel.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromAddress(String fromAddress);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that
         * you want to use when you send email through the channel.
         * </p>
         * 
         * @param identity
         *        <p>
         *        The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon
         *        SES), that you want to use when you send email through the channel.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * <p>
         * The ARN of the AWS Identity and Access Management (IAM) role that you want Amazon Pinpoint to use when it
         * submits email-related event data for the channel.
         * </p>
         * 
         * @param roleArn
         *        <p>
         *        The ARN of the AWS Identity and Access Management (IAM) role that you want Amazon Pinpoint to use when
         *        it submits email-related event data for the channel.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String configurationSet;

        private Boolean enabled;

        private String fromAddress;

        private String identity;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailChannelRequest model) {
            configurationSet(model.configurationSet);
            enabled(model.enabled);
            fromAddress(model.fromAddress);
            identity(model.identity);
            roleArn(model.roleArn);
        }

        public final String getConfigurationSet() {
            return configurationSet;
        }

        public final void setConfigurationSet(String configurationSet) {
            this.configurationSet = configurationSet;
        }

        @Override
        @Transient
        public final Builder configurationSet(String configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getFromAddress() {
            return fromAddress;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        @Override
        @Transient
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final String getIdentity() {
            return identity;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        @Override
        @Transient
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public EmailChannelRequest build() {
            return new EmailChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
