/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.ApplicationResponse;
import software.amazon.awssdk.services.pinpoint.model.ListOfApplicationResponseCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationsResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationsResponse> {
    private static final SdkField<List<ApplicationResponse>> ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Item").getter(ApplicationsResponse.getter(ApplicationsResponse::item)).setter(ApplicationsResponse.setter(Builder::item)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ApplicationsResponse.getter(ApplicationsResponse::nextToken)).setter(ApplicationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationsResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ApplicationResponse> item;
    private final String nextToken;

    private ApplicationsResponse(BuilderImpl builder) {
        this.item = builder.item;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasItem() {
        return this.item != null && !(this.item instanceof SdkAutoConstructList);
    }

    public final List<ApplicationResponse> item() {
        return this.item;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItem() ? this.item() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationsResponse)) {
            return false;
        }
        ApplicationsResponse other = (ApplicationsResponse)obj;
        return this.hasItem() == other.hasItem() && Objects.equals(this.item(), other.item()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationsResponse").add("Item", this.hasItem() ? this.item() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Item", ITEM_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationsResponse, T> g) {
        return obj -> g.apply((ApplicationsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ApplicationResponse> item = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationsResponse model) {
            this.item(model.item);
            this.nextToken(model.nextToken);
        }

        public final List<ApplicationResponse.Builder> getItem() {
            List<ApplicationResponse.Builder> result = ListOfApplicationResponseCopier.copyToBuilder(this.item);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItem(Collection<ApplicationResponse.BuilderImpl> item) {
            this.item = ListOfApplicationResponseCopier.copyFromBuilder(item);
        }

        @Override
        public final Builder item(Collection<ApplicationResponse> item) {
            this.item = ListOfApplicationResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(ApplicationResponse ... item) {
            this.item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<ApplicationResponse.Builder> ... item) {
            this.item(Stream.of(item).map(c -> (ApplicationResponse)((ApplicationResponse.Builder)ApplicationResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public ApplicationsResponse build() {
            return new ApplicationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationsResponse> {
        public Builder item(Collection<ApplicationResponse> var1);

        public Builder item(ApplicationResponse ... var1);

        public Builder item(Consumer<ApplicationResponse.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

