/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BaiduChannelRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BaiduChannelRequest> {
    private static final SdkField<String> API_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiKey").getter(BaiduChannelRequest.getter(BaiduChannelRequest::apiKey)).setter(BaiduChannelRequest.setter(Builder::apiKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKey").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(BaiduChannelRequest.getter(BaiduChannelRequest::enabled)).setter(BaiduChannelRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> SECRET_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretKey").getter(BaiduChannelRequest.getter(BaiduChannelRequest::secretKey)).setter(BaiduChannelRequest.setter(Builder::secretKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_FIELD, ENABLED_FIELD, SECRET_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BaiduChannelRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String apiKey;
    private final Boolean enabled;
    private final String secretKey;

    private BaiduChannelRequest(BuilderImpl builder) {
        this.apiKey = builder.apiKey;
        this.enabled = builder.enabled;
        this.secretKey = builder.secretKey;
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String secretKey() {
        return this.secretKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaiduChannelRequest)) {
            return false;
        }
        BaiduChannelRequest other = (BaiduChannelRequest)obj;
        return Objects.equals(this.apiKey(), other.apiKey()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.secretKey(), other.secretKey());
    }

    public final String toString() {
        return ToString.builder((String)"BaiduChannelRequest").add("ApiKey", (Object)this.apiKey()).add("Enabled", (Object)this.enabled()).add("SecretKey", (Object)this.secretKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiKey": {
                return Optional.ofNullable(clazz.cast(this.apiKey()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "SecretKey": {
                return Optional.ofNullable(clazz.cast(this.secretKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApiKey", API_KEY_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("SecretKey", SECRET_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BaiduChannelRequest, T> g) {
        return obj -> g.apply((BaiduChannelRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiKey;
        private Boolean enabled;
        private String secretKey;

        private BuilderImpl() {
        }

        private BuilderImpl(BaiduChannelRequest model) {
            this.apiKey(model.apiKey);
            this.enabled(model.enabled);
            this.secretKey(model.secretKey);
        }

        public final String getApiKey() {
            return this.apiKey;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getSecretKey() {
            return this.secretKey;
        }

        public final void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        @Override
        public final Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public BaiduChannelRequest build() {
            return new BaiduChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BaiduChannelRequest> {
        public Builder apiKey(String var1);

        public Builder enabled(Boolean var1);

        public Builder secretKey(String var1);
    }
}

