/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOptOutListResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, CreateOptOutListResponse> {
    private static final SdkField<String> OPT_OUT_LIST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptOutListArn").getter(CreateOptOutListResponse.getter(CreateOptOutListResponse::optOutListArn)).setter(CreateOptOutListResponse.setter(Builder::optOutListArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListArn").build()}).build();
    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptOutListName").getter(CreateOptOutListResponse.getter(CreateOptOutListResponse::optOutListName)).setter(CreateOptOutListResponse.setter(Builder::optOutListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateOptOutListResponse.getter(CreateOptOutListResponse::tags)).setter(CreateOptOutListResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(CreateOptOutListResponse.getter(CreateOptOutListResponse::createdTimestamp)).setter(CreateOptOutListResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_OUT_LIST_ARN_FIELD, OPT_OUT_LIST_NAME_FIELD, TAGS_FIELD, CREATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateOptOutListResponse.memberNameToFieldInitializer();
    private final String optOutListArn;
    private final String optOutListName;
    private final List<Tag> tags;
    private final Instant createdTimestamp;

    private CreateOptOutListResponse(BuilderImpl builder) {
        super(builder);
        this.optOutListArn = builder.optOutListArn;
        this.optOutListName = builder.optOutListName;
        this.tags = builder.tags;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public final String optOutListArn() {
        return this.optOutListArn;
    }

    public final String optOutListName() {
        return this.optOutListName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.optOutListArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOptOutListResponse)) {
            return false;
        }
        CreateOptOutListResponse other = (CreateOptOutListResponse)((Object)obj);
        return Objects.equals(this.optOutListArn(), other.optOutListArn()) && Objects.equals(this.optOutListName(), other.optOutListName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOptOutListResponse").add("OptOutListArn", (Object)this.optOutListArn()).add("OptOutListName", (Object)this.optOutListName()).add("Tags", this.hasTags() ? this.tags() : null).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptOutListArn": {
                return Optional.ofNullable(clazz.cast(this.optOutListArn()));
            }
            case "OptOutListName": {
                return Optional.ofNullable(clazz.cast(this.optOutListName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OptOutListArn", OPT_OUT_LIST_ARN_FIELD);
        map.put("OptOutListName", OPT_OUT_LIST_NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOptOutListResponse, T> g) {
        return obj -> g.apply((CreateOptOutListResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String optOutListArn;
        private String optOutListName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOptOutListResponse model) {
            super(model);
            this.optOutListArn(model.optOutListArn);
            this.optOutListName(model.optOutListName);
            this.tags(model.tags);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final String getOptOutListArn() {
            return this.optOutListArn;
        }

        public final void setOptOutListArn(String optOutListArn) {
            this.optOutListArn = optOutListArn;
        }

        @Override
        public final Builder optOutListArn(String optOutListArn) {
            this.optOutListArn = optOutListArn;
            return this;
        }

        public final String getOptOutListName() {
            return this.optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public CreateOptOutListResponse build() {
            return new CreateOptOutListResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOptOutListResponse> {
        public Builder optOutListArn(String var1);

        public Builder optOutListName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder createdTimestamp(Instant var1);
    }
}

