/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationFilter;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationFilterListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProtectConfigurationsRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, DescribeProtectConfigurationsRequest> {
    private static final SdkField<List<String>> PROTECT_CONFIGURATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProtectConfigurationIds").getter(DescribeProtectConfigurationsRequest.getter(DescribeProtectConfigurationsRequest::protectConfigurationIds)).setter(DescribeProtectConfigurationsRequest.setter(Builder::protectConfigurationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProtectConfigurationFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeProtectConfigurationsRequest.getter(DescribeProtectConfigurationsRequest::filters)).setter(DescribeProtectConfigurationsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProtectConfigurationFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeProtectConfigurationsRequest.getter(DescribeProtectConfigurationsRequest::nextToken)).setter(DescribeProtectConfigurationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeProtectConfigurationsRequest.getter(DescribeProtectConfigurationsRequest::maxResults)).setter(DescribeProtectConfigurationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECT_CONFIGURATION_IDS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeProtectConfigurationsRequest.memberNameToFieldInitializer();
    private final List<String> protectConfigurationIds;
    private final List<ProtectConfigurationFilter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeProtectConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationIds = builder.protectConfigurationIds;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasProtectConfigurationIds() {
        return this.protectConfigurationIds != null && !(this.protectConfigurationIds instanceof SdkAutoConstructList);
    }

    public final List<String> protectConfigurationIds() {
        return this.protectConfigurationIds;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<ProtectConfigurationFilter> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtectConfigurationIds() ? this.protectConfigurationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProtectConfigurationsRequest)) {
            return false;
        }
        DescribeProtectConfigurationsRequest other = (DescribeProtectConfigurationsRequest)((Object)obj);
        return this.hasProtectConfigurationIds() == other.hasProtectConfigurationIds() && Objects.equals(this.protectConfigurationIds(), other.protectConfigurationIds()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProtectConfigurationsRequest").add("ProtectConfigurationIds", this.hasProtectConfigurationIds() ? this.protectConfigurationIds() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectConfigurationIds": {
                return Optional.ofNullable(clazz.cast(this.protectConfigurationIds()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProtectConfigurationIds", PROTECT_CONFIGURATION_IDS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProtectConfigurationsRequest, T> g) {
        return obj -> g.apply((DescribeProtectConfigurationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private List<String> protectConfigurationIds = DefaultSdkAutoConstructList.getInstance();
        private List<ProtectConfigurationFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProtectConfigurationsRequest model) {
            super(model);
            this.protectConfigurationIds(model.protectConfigurationIds);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getProtectConfigurationIds() {
            if (this.protectConfigurationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protectConfigurationIds;
        }

        public final void setProtectConfigurationIds(Collection<String> protectConfigurationIds) {
            this.protectConfigurationIds = ProtectConfigurationIdListCopier.copy(protectConfigurationIds);
        }

        @Override
        public final Builder protectConfigurationIds(Collection<String> protectConfigurationIds) {
            this.protectConfigurationIds = ProtectConfigurationIdListCopier.copy(protectConfigurationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectConfigurationIds(String ... protectConfigurationIds) {
            this.protectConfigurationIds(Arrays.asList(protectConfigurationIds));
            return this;
        }

        public final List<ProtectConfigurationFilter.Builder> getFilters() {
            List<ProtectConfigurationFilter.Builder> result = ProtectConfigurationFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<ProtectConfigurationFilter.BuilderImpl> filters) {
            this.filters = ProtectConfigurationFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<ProtectConfigurationFilter> filters) {
            this.filters = ProtectConfigurationFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ProtectConfigurationFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ProtectConfigurationFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (ProtectConfigurationFilter)((ProtectConfigurationFilter.Builder)ProtectConfigurationFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeProtectConfigurationsRequest build() {
            return new DescribeProtectConfigurationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProtectConfigurationsRequest> {
        public Builder protectConfigurationIds(Collection<String> var1);

        public Builder protectConfigurationIds(String ... var1);

        public Builder filters(Collection<ProtectConfigurationFilter> var1);

        public Builder filters(ProtectConfigurationFilter ... var1);

        public Builder filters(Consumer<ProtectConfigurationFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

