/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.privatenetworks.model.CommitmentConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommitmentInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommitmentInformation> {
    private static final SdkField<CommitmentConfiguration> COMMITMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("commitmentConfiguration").getter(CommitmentInformation.getter(CommitmentInformation::commitmentConfiguration)).setter(CommitmentInformation.setter(Builder::commitmentConfiguration)).constructor(CommitmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentConfiguration").build()}).build();
    private static final SdkField<Instant> EXPIRES_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiresOn").getter(CommitmentInformation.getter(CommitmentInformation::expiresOn)).setter(CommitmentInformation.setter(Builder::expiresOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresOn").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> START_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startAt").getter(CommitmentInformation.getter(CommitmentInformation::startAt)).setter(CommitmentInformation.setter(Builder::startAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMITMENT_CONFIGURATION_FIELD, EXPIRES_ON_FIELD, START_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CommitmentInformation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CommitmentConfiguration commitmentConfiguration;
    private final Instant expiresOn;
    private final Instant startAt;

    private CommitmentInformation(BuilderImpl builder) {
        this.commitmentConfiguration = builder.commitmentConfiguration;
        this.expiresOn = builder.expiresOn;
        this.startAt = builder.startAt;
    }

    public final CommitmentConfiguration commitmentConfiguration() {
        return this.commitmentConfiguration;
    }

    public final Instant expiresOn() {
        return this.expiresOn;
    }

    public final Instant startAt() {
        return this.startAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commitmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitmentInformation)) {
            return false;
        }
        CommitmentInformation other = (CommitmentInformation)obj;
        return Objects.equals(this.commitmentConfiguration(), other.commitmentConfiguration()) && Objects.equals(this.expiresOn(), other.expiresOn()) && Objects.equals(this.startAt(), other.startAt());
    }

    public final String toString() {
        return ToString.builder((String)"CommitmentInformation").add("CommitmentConfiguration", (Object)this.commitmentConfiguration()).add("ExpiresOn", (Object)this.expiresOn()).add("StartAt", (Object)this.startAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commitmentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.commitmentConfiguration()));
            }
            case "expiresOn": {
                return Optional.ofNullable(clazz.cast(this.expiresOn()));
            }
            case "startAt": {
                return Optional.ofNullable(clazz.cast(this.startAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("commitmentConfiguration", COMMITMENT_CONFIGURATION_FIELD);
        map.put("expiresOn", EXPIRES_ON_FIELD);
        map.put("startAt", START_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommitmentInformation, T> g) {
        return obj -> g.apply((CommitmentInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CommitmentConfiguration commitmentConfiguration;
        private Instant expiresOn;
        private Instant startAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CommitmentInformation model) {
            this.commitmentConfiguration(model.commitmentConfiguration);
            this.expiresOn(model.expiresOn);
            this.startAt(model.startAt);
        }

        public final CommitmentConfiguration.Builder getCommitmentConfiguration() {
            return this.commitmentConfiguration != null ? this.commitmentConfiguration.toBuilder() : null;
        }

        public final void setCommitmentConfiguration(CommitmentConfiguration.BuilderImpl commitmentConfiguration) {
            this.commitmentConfiguration = commitmentConfiguration != null ? commitmentConfiguration.build() : null;
        }

        @Override
        public final Builder commitmentConfiguration(CommitmentConfiguration commitmentConfiguration) {
            this.commitmentConfiguration = commitmentConfiguration;
            return this;
        }

        public final Instant getExpiresOn() {
            return this.expiresOn;
        }

        public final void setExpiresOn(Instant expiresOn) {
            this.expiresOn = expiresOn;
        }

        @Override
        public final Builder expiresOn(Instant expiresOn) {
            this.expiresOn = expiresOn;
            return this;
        }

        public final Instant getStartAt() {
            return this.startAt;
        }

        public final void setStartAt(Instant startAt) {
            this.startAt = startAt;
        }

        @Override
        public final Builder startAt(Instant startAt) {
            this.startAt = startAt;
            return this;
        }

        public CommitmentInformation build() {
            return new CommitmentInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommitmentInformation> {
        public Builder commitmentConfiguration(CommitmentConfiguration var1);

        default public Builder commitmentConfiguration(Consumer<CommitmentConfiguration.Builder> commitmentConfiguration) {
            return this.commitmentConfiguration((CommitmentConfiguration)((CommitmentConfiguration.Builder)CommitmentConfiguration.builder().applyMutation(commitmentConfiguration)).build());
        }

        public Builder expiresOn(Instant var1);

        public Builder startAt(Instant var1);
    }
}

