/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceIdentifier> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DeviceIdentifier.getter(DeviceIdentifier::createdAt)).setter(DeviceIdentifier.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DEVICE_IDENTIFIER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceIdentifierArn").getter(DeviceIdentifier.getter(DeviceIdentifier::deviceIdentifierArn)).setter(DeviceIdentifier.setter(Builder::deviceIdentifierArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceIdentifierArn").build()}).build();
    private static final SdkField<String> ICCID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iccid").getter(DeviceIdentifier.getter(DeviceIdentifier::iccid)).setter(DeviceIdentifier.setter(Builder::iccid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iccid").build()}).build();
    private static final SdkField<String> IMSI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imsi").getter(DeviceIdentifier.getter(DeviceIdentifier::imsi)).setter(DeviceIdentifier.setter(Builder::imsi)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imsi").build()}).build();
    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkArn").getter(DeviceIdentifier.getter(DeviceIdentifier::networkArn)).setter(DeviceIdentifier.setter(Builder::networkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()}).build();
    private static final SdkField<String> ORDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("orderArn").getter(DeviceIdentifier.getter(DeviceIdentifier::orderArn)).setter(DeviceIdentifier.setter(Builder::orderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeviceIdentifier.getter(DeviceIdentifier::statusAsString)).setter(DeviceIdentifier.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TRAFFIC_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trafficGroupArn").getter(DeviceIdentifier.getter(DeviceIdentifier::trafficGroupArn)).setter(DeviceIdentifier.setter(Builder::trafficGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trafficGroupArn").build()}).build();
    private static final SdkField<String> VENDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vendor").getter(DeviceIdentifier.getter(DeviceIdentifier::vendor)).setter(DeviceIdentifier.setter(Builder::vendor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DEVICE_IDENTIFIER_ARN_FIELD, ICCID_FIELD, IMSI_FIELD, NETWORK_ARN_FIELD, ORDER_ARN_FIELD, STATUS_FIELD, TRAFFIC_GROUP_ARN_FIELD, VENDOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeviceIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String deviceIdentifierArn;
    private final String iccid;
    private final String imsi;
    private final String networkArn;
    private final String orderArn;
    private final String status;
    private final String trafficGroupArn;
    private final String vendor;

    private DeviceIdentifier(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.deviceIdentifierArn = builder.deviceIdentifierArn;
        this.iccid = builder.iccid;
        this.imsi = builder.imsi;
        this.networkArn = builder.networkArn;
        this.orderArn = builder.orderArn;
        this.status = builder.status;
        this.trafficGroupArn = builder.trafficGroupArn;
        this.vendor = builder.vendor;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String deviceIdentifierArn() {
        return this.deviceIdentifierArn;
    }

    public final String iccid() {
        return this.iccid;
    }

    public final String imsi() {
        return this.imsi;
    }

    public final String networkArn() {
        return this.networkArn;
    }

    public final String orderArn() {
        return this.orderArn;
    }

    public final DeviceIdentifierStatus status() {
        return DeviceIdentifierStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String trafficGroupArn() {
        return this.trafficGroupArn;
    }

    public final String vendor() {
        return this.vendor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceIdentifierArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iccid());
        hashCode = 31 * hashCode + Objects.hashCode(this.imsi());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceIdentifier)) {
            return false;
        }
        DeviceIdentifier other = (DeviceIdentifier)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deviceIdentifierArn(), other.deviceIdentifierArn()) && Objects.equals(this.iccid(), other.iccid()) && Objects.equals(this.imsi(), other.imsi()) && Objects.equals(this.networkArn(), other.networkArn()) && Objects.equals(this.orderArn(), other.orderArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.trafficGroupArn(), other.trafficGroupArn()) && Objects.equals(this.vendor(), other.vendor());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceIdentifier").add("CreatedAt", (Object)this.createdAt()).add("DeviceIdentifierArn", (Object)this.deviceIdentifierArn()).add("Iccid", (Object)this.iccid()).add("Imsi", (Object)(this.imsi() == null ? null : "*** Sensitive Data Redacted ***")).add("NetworkArn", (Object)this.networkArn()).add("OrderArn", (Object)this.orderArn()).add("Status", (Object)this.statusAsString()).add("TrafficGroupArn", (Object)this.trafficGroupArn()).add("Vendor", (Object)this.vendor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "deviceIdentifierArn": {
                return Optional.ofNullable(clazz.cast(this.deviceIdentifierArn()));
            }
            case "iccid": {
                return Optional.ofNullable(clazz.cast(this.iccid()));
            }
            case "imsi": {
                return Optional.ofNullable(clazz.cast(this.imsi()));
            }
            case "networkArn": {
                return Optional.ofNullable(clazz.cast(this.networkArn()));
            }
            case "orderArn": {
                return Optional.ofNullable(clazz.cast(this.orderArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "trafficGroupArn": {
                return Optional.ofNullable(clazz.cast(this.trafficGroupArn()));
            }
            case "vendor": {
                return Optional.ofNullable(clazz.cast(this.vendor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("deviceIdentifierArn", DEVICE_IDENTIFIER_ARN_FIELD);
        map.put("iccid", ICCID_FIELD);
        map.put("imsi", IMSI_FIELD);
        map.put("networkArn", NETWORK_ARN_FIELD);
        map.put("orderArn", ORDER_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("trafficGroupArn", TRAFFIC_GROUP_ARN_FIELD);
        map.put("vendor", VENDOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceIdentifier, T> g) {
        return obj -> g.apply((DeviceIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String deviceIdentifierArn;
        private String iccid;
        private String imsi;
        private String networkArn;
        private String orderArn;
        private String status;
        private String trafficGroupArn;
        private String vendor;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceIdentifier model) {
            this.createdAt(model.createdAt);
            this.deviceIdentifierArn(model.deviceIdentifierArn);
            this.iccid(model.iccid);
            this.imsi(model.imsi);
            this.networkArn(model.networkArn);
            this.orderArn(model.orderArn);
            this.status(model.status);
            this.trafficGroupArn(model.trafficGroupArn);
            this.vendor(model.vendor);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDeviceIdentifierArn() {
            return this.deviceIdentifierArn;
        }

        public final void setDeviceIdentifierArn(String deviceIdentifierArn) {
            this.deviceIdentifierArn = deviceIdentifierArn;
        }

        @Override
        public final Builder deviceIdentifierArn(String deviceIdentifierArn) {
            this.deviceIdentifierArn = deviceIdentifierArn;
            return this;
        }

        public final String getIccid() {
            return this.iccid;
        }

        public final void setIccid(String iccid) {
            this.iccid = iccid;
        }

        @Override
        public final Builder iccid(String iccid) {
            this.iccid = iccid;
            return this;
        }

        public final String getImsi() {
            return this.imsi;
        }

        public final void setImsi(String imsi) {
            this.imsi = imsi;
        }

        @Override
        public final Builder imsi(String imsi) {
            this.imsi = imsi;
            return this;
        }

        public final String getNetworkArn() {
            return this.networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final String getOrderArn() {
            return this.orderArn;
        }

        public final void setOrderArn(String orderArn) {
            this.orderArn = orderArn;
        }

        @Override
        public final Builder orderArn(String orderArn) {
            this.orderArn = orderArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeviceIdentifierStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTrafficGroupArn() {
            return this.trafficGroupArn;
        }

        public final void setTrafficGroupArn(String trafficGroupArn) {
            this.trafficGroupArn = trafficGroupArn;
        }

        @Override
        public final Builder trafficGroupArn(String trafficGroupArn) {
            this.trafficGroupArn = trafficGroupArn;
            return this;
        }

        public final String getVendor() {
            return this.vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public DeviceIdentifier build() {
            return new DeviceIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceIdentifier> {
        public Builder createdAt(Instant var1);

        public Builder deviceIdentifierArn(String var1);

        public Builder iccid(String var1);

        public Builder imsi(String var1);

        public Builder networkArn(String var1);

        public Builder orderArn(String var1);

        public Builder status(String var1);

        public Builder status(DeviceIdentifierStatus var1);

        public Builder trafficGroupArn(String var1);

        public Builder vendor(String var1);
    }
}

