/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ElevationReference {
    AGL("AGL"),
    AMSL("AMSL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ElevationReference> VALUE_MAP;
    private final String value;

    private ElevationReference(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ElevationReference fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ElevationReference> knownValues() {
        EnumSet<ElevationReference> knownValues = EnumSet.allOf(ElevationReference.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ElevationReference.class, ElevationReference::toString);
    }
}

