/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkResourceDefinitionType {
    RADIO_UNIT("RADIO_UNIT"),
    DEVICE_IDENTIFIER("DEVICE_IDENTIFIER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkResourceDefinitionType> VALUE_MAP;
    private final String value;

    private NetworkResourceDefinitionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkResourceDefinitionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkResourceDefinitionType> knownValues() {
        EnumSet<NetworkResourceDefinitionType> knownValues = EnumSet.allOf(NetworkResourceDefinitionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkResourceDefinitionType.class, NetworkResourceDefinitionType::toString);
    }
}

