/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkResourceStatus {
    PENDING("PENDING"),
    SHIPPED("SHIPPED"),
    PROVISIONING("PROVISIONING"),
    PROVISIONED("PROVISIONED"),
    AVAILABLE("AVAILABLE"),
    DELETING("DELETING"),
    PENDING_RETURN("PENDING_RETURN"),
    DELETED("DELETED"),
    CREATING_SHIPPING_LABEL("CREATING_SHIPPING_LABEL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkResourceStatus> VALUE_MAP;
    private final String value;

    private NetworkResourceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkResourceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkResourceStatus> knownValues() {
        EnumSet<NetworkResourceStatus> knownValues = EnumSet.allOf(NetworkResourceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkResourceStatus.class, NetworkResourceStatus::toString);
    }
}

