/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentState> {
    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceInstanceName").getter(ComponentState.getter(ComponentState::serviceInstanceName)).setter(ComponentState.setter(Builder::serviceInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(ComponentState.getter(ComponentState::serviceName)).setter(ComponentState.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> SERVICE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceSpec").getter(ComponentState.getter(ComponentState::serviceSpec)).setter(ComponentState.setter(Builder::serviceSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceSpec").build()}).build();
    private static final SdkField<String> TEMPLATE_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateFile").getter(ComponentState.getter(ComponentState::templateFile)).setter(ComponentState.setter(Builder::templateFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateFile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_INSTANCE_NAME_FIELD, SERVICE_NAME_FIELD, SERVICE_SPEC_FIELD, TEMPLATE_FILE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComponentState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceInstanceName;
    private final String serviceName;
    private final String serviceSpec;
    private final String templateFile;

    private ComponentState(BuilderImpl builder) {
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
        this.serviceSpec = builder.serviceSpec;
        this.templateFile = builder.templateFile;
    }

    public final String serviceInstanceName() {
        return this.serviceInstanceName;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String serviceSpec() {
        return this.serviceSpec;
    }

    public final String templateFile() {
        return this.templateFile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateFile());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentState)) {
            return false;
        }
        ComponentState other = (ComponentState)obj;
        return Objects.equals(this.serviceInstanceName(), other.serviceInstanceName()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceSpec(), other.serviceSpec()) && Objects.equals(this.templateFile(), other.templateFile());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentState").add("ServiceInstanceName", (Object)this.serviceInstanceName()).add("ServiceName", (Object)this.serviceName()).add("ServiceSpec", (Object)(this.serviceSpec() == null ? null : "*** Sensitive Data Redacted ***")).add("TemplateFile", (Object)(this.templateFile() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceInstanceName": {
                return Optional.ofNullable(clazz.cast(this.serviceInstanceName()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "serviceSpec": {
                return Optional.ofNullable(clazz.cast(this.serviceSpec()));
            }
            case "templateFile": {
                return Optional.ofNullable(clazz.cast(this.templateFile()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("serviceInstanceName", SERVICE_INSTANCE_NAME_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("serviceSpec", SERVICE_SPEC_FIELD);
        map.put("templateFile", TEMPLATE_FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentState, T> g) {
        return obj -> g.apply((ComponentState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceInstanceName;
        private String serviceName;
        private String serviceSpec;
        private String templateFile;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentState model) {
            this.serviceInstanceName(model.serviceInstanceName);
            this.serviceName(model.serviceName);
            this.serviceSpec(model.serviceSpec);
            this.templateFile(model.templateFile);
        }

        public final String getServiceInstanceName() {
            return this.serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceSpec() {
            return this.serviceSpec;
        }

        public final void setServiceSpec(String serviceSpec) {
            this.serviceSpec = serviceSpec;
        }

        @Override
        public final Builder serviceSpec(String serviceSpec) {
            this.serviceSpec = serviceSpec;
            return this;
        }

        public final String getTemplateFile() {
            return this.templateFile;
        }

        public final void setTemplateFile(String templateFile) {
            this.templateFile = templateFile;
        }

        @Override
        public final Builder templateFile(String templateFile) {
            this.templateFile = templateFile;
            return this;
        }

        public ComponentState build() {
            return new ComponentState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentState> {
        public Builder serviceInstanceName(String var1);

        public Builder serviceName(String var1);

        public Builder serviceSpec(String var1);

        public Builder templateFile(String var1);
    }
}

