/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.DeploymentStatus;
import software.amazon.awssdk.services.proton.model.DeploymentTargetResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DeploymentSummary.getter(DeploymentSummary::arn)).setter(DeploymentSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completedAt").getter(DeploymentSummary.getter(DeploymentSummary::completedAt)).setter(DeploymentSummary.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(DeploymentSummary.getter(DeploymentSummary::componentName)).setter(DeploymentSummary.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DeploymentSummary.getter(DeploymentSummary::createdAt)).setter(DeploymentSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentStatus").getter(DeploymentSummary.getter(DeploymentSummary::deploymentStatusAsString)).setter(DeploymentSummary.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(DeploymentSummary.getter(DeploymentSummary::environmentName)).setter(DeploymentSummary.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DeploymentSummary.getter(DeploymentSummary::id)).setter(DeploymentSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastAttemptedDeploymentId").getter(DeploymentSummary.getter(DeploymentSummary::lastAttemptedDeploymentId)).setter(DeploymentSummary.setter(Builder::lastAttemptedDeploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAttemptedDeploymentId").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(DeploymentSummary.getter(DeploymentSummary::lastModifiedAt)).setter(DeploymentSummary.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()}).build();
    private static final SdkField<String> LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastSucceededDeploymentId").getter(DeploymentSummary.getter(DeploymentSummary::lastSucceededDeploymentId)).setter(DeploymentSummary.setter(Builder::lastSucceededDeploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSucceededDeploymentId").build()}).build();
    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceInstanceName").getter(DeploymentSummary.getter(DeploymentSummary::serviceInstanceName)).setter(DeploymentSummary.setter(Builder::serviceInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(DeploymentSummary.getter(DeploymentSummary::serviceName)).setter(DeploymentSummary.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(DeploymentSummary.getter(DeploymentSummary::targetArn)).setter(DeploymentSummary.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<Instant> TARGET_RESOURCE_CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("targetResourceCreatedAt").getter(DeploymentSummary.getter(DeploymentSummary::targetResourceCreatedAt)).setter(DeploymentSummary.setter(Builder::targetResourceCreatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceCreatedAt").build()}).build();
    private static final SdkField<String> TARGET_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetResourceType").getter(DeploymentSummary.getter(DeploymentSummary::targetResourceTypeAsString)).setter(DeploymentSummary.setter(Builder::targetResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COMPLETED_AT_FIELD, COMPONENT_NAME_FIELD, CREATED_AT_FIELD, DEPLOYMENT_STATUS_FIELD, ENVIRONMENT_NAME_FIELD, ID_FIELD, LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD, LAST_MODIFIED_AT_FIELD, LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD, SERVICE_INSTANCE_NAME_FIELD, SERVICE_NAME_FIELD, TARGET_ARN_FIELD, TARGET_RESOURCE_CREATED_AT_FIELD, TARGET_RESOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeploymentSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant completedAt;
    private final String componentName;
    private final Instant createdAt;
    private final String deploymentStatus;
    private final String environmentName;
    private final String id;
    private final String lastAttemptedDeploymentId;
    private final Instant lastModifiedAt;
    private final String lastSucceededDeploymentId;
    private final String serviceInstanceName;
    private final String serviceName;
    private final String targetArn;
    private final Instant targetResourceCreatedAt;
    private final String targetResourceType;

    private DeploymentSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.completedAt = builder.completedAt;
        this.componentName = builder.componentName;
        this.createdAt = builder.createdAt;
        this.deploymentStatus = builder.deploymentStatus;
        this.environmentName = builder.environmentName;
        this.id = builder.id;
        this.lastAttemptedDeploymentId = builder.lastAttemptedDeploymentId;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.lastSucceededDeploymentId = builder.lastSucceededDeploymentId;
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
        this.targetArn = builder.targetArn;
        this.targetResourceCreatedAt = builder.targetResourceCreatedAt;
        this.targetResourceType = builder.targetResourceType;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant completedAt() {
        return this.completedAt;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(this.deploymentStatus);
    }

    public final String deploymentStatusAsString() {
        return this.deploymentStatus;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String id() {
        return this.id;
    }

    public final String lastAttemptedDeploymentId() {
        return this.lastAttemptedDeploymentId;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final String lastSucceededDeploymentId() {
        return this.lastSucceededDeploymentId;
    }

    public final String serviceInstanceName() {
        return this.serviceInstanceName;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final Instant targetResourceCreatedAt() {
        return this.targetResourceCreatedAt;
    }

    public final DeploymentTargetResourceType targetResourceType() {
        return DeploymentTargetResourceType.fromValue(this.targetResourceType);
    }

    public final String targetResourceTypeAsString() {
        return this.targetResourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAttemptedDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSucceededDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResourceCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentSummary)) {
            return false;
        }
        DeploymentSummary other = (DeploymentSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deploymentStatusAsString(), other.deploymentStatusAsString()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastAttemptedDeploymentId(), other.lastAttemptedDeploymentId()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.lastSucceededDeploymentId(), other.lastSucceededDeploymentId()) && Objects.equals(this.serviceInstanceName(), other.serviceInstanceName()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.targetResourceCreatedAt(), other.targetResourceCreatedAt()) && Objects.equals(this.targetResourceTypeAsString(), other.targetResourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentSummary").add("Arn", (Object)this.arn()).add("CompletedAt", (Object)this.completedAt()).add("ComponentName", (Object)this.componentName()).add("CreatedAt", (Object)this.createdAt()).add("DeploymentStatus", (Object)this.deploymentStatusAsString()).add("EnvironmentName", (Object)this.environmentName()).add("Id", (Object)this.id()).add("LastAttemptedDeploymentId", (Object)this.lastAttemptedDeploymentId()).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("LastSucceededDeploymentId", (Object)this.lastSucceededDeploymentId()).add("ServiceInstanceName", (Object)this.serviceInstanceName()).add("ServiceName", (Object)this.serviceName()).add("TargetArn", (Object)this.targetArn()).add("TargetResourceCreatedAt", (Object)this.targetResourceCreatedAt()).add("TargetResourceType", (Object)this.targetResourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "completedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "deploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusAsString()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastAttemptedDeploymentId": {
                return Optional.ofNullable(clazz.cast(this.lastAttemptedDeploymentId()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "lastSucceededDeploymentId": {
                return Optional.ofNullable(clazz.cast(this.lastSucceededDeploymentId()));
            }
            case "serviceInstanceName": {
                return Optional.ofNullable(clazz.cast(this.serviceInstanceName()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "targetResourceCreatedAt": {
                return Optional.ofNullable(clazz.cast(this.targetResourceCreatedAt()));
            }
            case "targetResourceType": {
                return Optional.ofNullable(clazz.cast(this.targetResourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("completedAt", COMPLETED_AT_FIELD);
        map.put("componentName", COMPONENT_NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("deploymentStatus", DEPLOYMENT_STATUS_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastAttemptedDeploymentId", LAST_ATTEMPTED_DEPLOYMENT_ID_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("lastSucceededDeploymentId", LAST_SUCCEEDED_DEPLOYMENT_ID_FIELD);
        map.put("serviceInstanceName", SERVICE_INSTANCE_NAME_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("targetResourceCreatedAt", TARGET_RESOURCE_CREATED_AT_FIELD);
        map.put("targetResourceType", TARGET_RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentSummary, T> g) {
        return obj -> g.apply((DeploymentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant completedAt;
        private String componentName;
        private Instant createdAt;
        private String deploymentStatus;
        private String environmentName;
        private String id;
        private String lastAttemptedDeploymentId;
        private Instant lastModifiedAt;
        private String lastSucceededDeploymentId;
        private String serviceInstanceName;
        private String serviceName;
        private String targetArn;
        private Instant targetResourceCreatedAt;
        private String targetResourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentSummary model) {
            this.arn(model.arn);
            this.completedAt(model.completedAt);
            this.componentName(model.componentName);
            this.createdAt(model.createdAt);
            this.deploymentStatus(model.deploymentStatus);
            this.environmentName(model.environmentName);
            this.id(model.id);
            this.lastAttemptedDeploymentId(model.lastAttemptedDeploymentId);
            this.lastModifiedAt(model.lastModifiedAt);
            this.lastSucceededDeploymentId(model.lastSucceededDeploymentId);
            this.serviceInstanceName(model.serviceInstanceName);
            this.serviceName(model.serviceName);
            this.targetArn(model.targetArn);
            this.targetResourceCreatedAt(model.targetResourceCreatedAt);
            this.targetResourceType(model.targetResourceType);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLastAttemptedDeploymentId() {
            return this.lastAttemptedDeploymentId;
        }

        public final void setLastAttemptedDeploymentId(String lastAttemptedDeploymentId) {
            this.lastAttemptedDeploymentId = lastAttemptedDeploymentId;
        }

        @Override
        public final Builder lastAttemptedDeploymentId(String lastAttemptedDeploymentId) {
            this.lastAttemptedDeploymentId = lastAttemptedDeploymentId;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getLastSucceededDeploymentId() {
            return this.lastSucceededDeploymentId;
        }

        public final void setLastSucceededDeploymentId(String lastSucceededDeploymentId) {
            this.lastSucceededDeploymentId = lastSucceededDeploymentId;
        }

        @Override
        public final Builder lastSucceededDeploymentId(String lastSucceededDeploymentId) {
            this.lastSucceededDeploymentId = lastSucceededDeploymentId;
            return this;
        }

        public final String getServiceInstanceName() {
            return this.serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final Instant getTargetResourceCreatedAt() {
            return this.targetResourceCreatedAt;
        }

        public final void setTargetResourceCreatedAt(Instant targetResourceCreatedAt) {
            this.targetResourceCreatedAt = targetResourceCreatedAt;
        }

        @Override
        public final Builder targetResourceCreatedAt(Instant targetResourceCreatedAt) {
            this.targetResourceCreatedAt = targetResourceCreatedAt;
            return this;
        }

        public final String getTargetResourceType() {
            return this.targetResourceType;
        }

        public final void setTargetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
        }

        @Override
        public final Builder targetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        @Override
        public final Builder targetResourceType(DeploymentTargetResourceType targetResourceType) {
            this.targetResourceType(targetResourceType == null ? null : targetResourceType.toString());
            return this;
        }

        public DeploymentSummary build() {
            return new DeploymentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentSummary> {
        public Builder arn(String var1);

        public Builder completedAt(Instant var1);

        public Builder componentName(String var1);

        public Builder createdAt(Instant var1);

        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(DeploymentStatus var1);

        public Builder environmentName(String var1);

        public Builder id(String var1);

        public Builder lastAttemptedDeploymentId(String var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder lastSucceededDeploymentId(String var1);

        public Builder serviceInstanceName(String var1);

        public Builder serviceName(String var1);

        public Builder targetArn(String var1);

        public Builder targetResourceCreatedAt(Instant var1);

        public Builder targetResourceType(String var1);

        public Builder targetResourceType(DeploymentTargetResourceType var1);
    }
}

