/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qapps.model.CardStatus;
import software.amazon.awssdk.services.qapps.model.CardStatusMapCopier;
import software.amazon.awssdk.services.qapps.model.ExecutionStatus;
import software.amazon.awssdk.services.qapps.model.QAppsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQAppSessionResponse
extends QAppsResponse
implements ToCopyableBuilder<Builder, GetQAppSessionResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(GetQAppSessionResponse.getter(GetQAppSessionResponse::sessionId)).setter(GetQAppSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionArn").getter(GetQAppSessionResponse.getter(GetQAppSessionResponse::sessionArn)).setter(GetQAppSessionResponse.setter(Builder::sessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()}).build();
    private static final SdkField<String> SESSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionName").getter(GetQAppSessionResponse.getter(GetQAppSessionResponse::sessionName)).setter(GetQAppSessionResponse.setter(Builder::sessionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionName").build()}).build();
    private static final SdkField<Integer> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("appVersion").getter(GetQAppSessionResponse.getter(GetQAppSessionResponse::appVersion)).setter(GetQAppSessionResponse.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<Integer> LATEST_PUBLISHED_APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("latestPublishedAppVersion").getter(GetQAppSessionResponse.getter(GetQAppSessionResponse::latestPublishedAppVersion)).setter(GetQAppSessionResponse.setter(Builder::latestPublishedAppVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestPublishedAppVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetQAppSessionResponse.getter(GetQAppSessionResponse::statusAsString)).setter(GetQAppSessionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, CardStatus>> CARD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("cardStatus").getter(GetQAppSessionResponse.getter(GetQAppSessionResponse::cardStatus)).setter(GetQAppSessionResponse.setter(Builder::cardStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardStatus").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CardStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USER_IS_HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("userIsHost").getter(GetQAppSessionResponse.getter(GetQAppSessionResponse::userIsHost)).setter(GetQAppSessionResponse.setter(Builder::userIsHost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIsHost").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, SESSION_ARN_FIELD, SESSION_NAME_FIELD, APP_VERSION_FIELD, LATEST_PUBLISHED_APP_VERSION_FIELD, STATUS_FIELD, CARD_STATUS_FIELD, USER_IS_HOST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetQAppSessionResponse.memberNameToFieldInitializer();
    private final String sessionId;
    private final String sessionArn;
    private final String sessionName;
    private final Integer appVersion;
    private final Integer latestPublishedAppVersion;
    private final String status;
    private final Map<String, CardStatus> cardStatus;
    private final Boolean userIsHost;

    private GetQAppSessionResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.sessionArn = builder.sessionArn;
        this.sessionName = builder.sessionName;
        this.appVersion = builder.appVersion;
        this.latestPublishedAppVersion = builder.latestPublishedAppVersion;
        this.status = builder.status;
        this.cardStatus = builder.cardStatus;
        this.userIsHost = builder.userIsHost;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String sessionArn() {
        return this.sessionArn;
    }

    public final String sessionName() {
        return this.sessionName;
    }

    public final Integer appVersion() {
        return this.appVersion;
    }

    public final Integer latestPublishedAppVersion() {
        return this.latestPublishedAppVersion;
    }

    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasCardStatus() {
        return this.cardStatus != null && !(this.cardStatus instanceof SdkAutoConstructMap);
    }

    public final Map<String, CardStatus> cardStatus() {
        return this.cardStatus;
    }

    public final Boolean userIsHost() {
        return this.userIsHost;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestPublishedAppVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCardStatus() ? this.cardStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userIsHost());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQAppSessionResponse)) {
            return false;
        }
        GetQAppSessionResponse other = (GetQAppSessionResponse)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.sessionArn(), other.sessionArn()) && Objects.equals(this.sessionName(), other.sessionName()) && Objects.equals(this.appVersion(), other.appVersion()) && Objects.equals(this.latestPublishedAppVersion(), other.latestPublishedAppVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasCardStatus() == other.hasCardStatus() && Objects.equals(this.cardStatus(), other.cardStatus()) && Objects.equals(this.userIsHost(), other.userIsHost());
    }

    public final String toString() {
        return ToString.builder((String)"GetQAppSessionResponse").add("SessionId", (Object)this.sessionId()).add("SessionArn", (Object)this.sessionArn()).add("SessionName", (Object)this.sessionName()).add("AppVersion", (Object)this.appVersion()).add("LatestPublishedAppVersion", (Object)this.latestPublishedAppVersion()).add("Status", (Object)this.statusAsString()).add("CardStatus", this.hasCardStatus() ? this.cardStatus() : null).add("UserIsHost", (Object)this.userIsHost()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "sessionArn": {
                return Optional.ofNullable(clazz.cast(this.sessionArn()));
            }
            case "sessionName": {
                return Optional.ofNullable(clazz.cast(this.sessionName()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "latestPublishedAppVersion": {
                return Optional.ofNullable(clazz.cast(this.latestPublishedAppVersion()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "cardStatus": {
                return Optional.ofNullable(clazz.cast(this.cardStatus()));
            }
            case "userIsHost": {
                return Optional.ofNullable(clazz.cast(this.userIsHost()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("sessionName", SESSION_NAME_FIELD);
        map.put("appVersion", APP_VERSION_FIELD);
        map.put("latestPublishedAppVersion", LATEST_PUBLISHED_APP_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("cardStatus", CARD_STATUS_FIELD);
        map.put("userIsHost", USER_IS_HOST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQAppSessionResponse, T> g) {
        return obj -> g.apply((GetQAppSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsResponse.BuilderImpl
    implements Builder {
        private String sessionId;
        private String sessionArn;
        private String sessionName;
        private Integer appVersion;
        private Integer latestPublishedAppVersion;
        private String status;
        private Map<String, CardStatus> cardStatus = DefaultSdkAutoConstructMap.getInstance();
        private Boolean userIsHost;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQAppSessionResponse model) {
            super(model);
            this.sessionId(model.sessionId);
            this.sessionArn(model.sessionArn);
            this.sessionName(model.sessionName);
            this.appVersion(model.appVersion);
            this.latestPublishedAppVersion(model.latestPublishedAppVersion);
            this.status(model.status);
            this.cardStatus(model.cardStatus);
            this.userIsHost(model.userIsHost);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionArn() {
            return this.sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getSessionName() {
            return this.sessionName;
        }

        public final void setSessionName(String sessionName) {
            this.sessionName = sessionName;
        }

        @Override
        public final Builder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public final Integer getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(Integer appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(Integer appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final Integer getLatestPublishedAppVersion() {
            return this.latestPublishedAppVersion;
        }

        public final void setLatestPublishedAppVersion(Integer latestPublishedAppVersion) {
            this.latestPublishedAppVersion = latestPublishedAppVersion;
        }

        @Override
        public final Builder latestPublishedAppVersion(Integer latestPublishedAppVersion) {
            this.latestPublishedAppVersion = latestPublishedAppVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, CardStatus.Builder> getCardStatus() {
            Map<String, CardStatus.Builder> result = CardStatusMapCopier.copyToBuilder(this.cardStatus);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCardStatus(Map<String, CardStatus.BuilderImpl> cardStatus) {
            this.cardStatus = CardStatusMapCopier.copyFromBuilder(cardStatus);
        }

        @Override
        public final Builder cardStatus(Map<String, CardStatus> cardStatus) {
            this.cardStatus = CardStatusMapCopier.copy(cardStatus);
            return this;
        }

        public final Boolean getUserIsHost() {
            return this.userIsHost;
        }

        public final void setUserIsHost(Boolean userIsHost) {
            this.userIsHost = userIsHost;
        }

        @Override
        public final Builder userIsHost(Boolean userIsHost) {
            this.userIsHost = userIsHost;
            return this;
        }

        @Override
        public GetQAppSessionResponse build() {
            return new GetQAppSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QAppsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQAppSessionResponse> {
        public Builder sessionId(String var1);

        public Builder sessionArn(String var1);

        public Builder sessionName(String var1);

        public Builder appVersion(Integer var1);

        public Builder latestPublishedAppVersion(Integer var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder cardStatus(Map<String, CardStatus> var1);

        public Builder userIsHost(Boolean var1);
    }
}

