/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qapps.model.PresignedUrlFieldsCopier;
import software.amazon.awssdk.services.qapps.model.QAppsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePresignedUrlResponse
extends QAppsResponse
implements ToCopyableBuilder<Builder, CreatePresignedUrlResponse> {
    private static final SdkField<String> FILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileId").getter(CreatePresignedUrlResponse.getter(CreatePresignedUrlResponse::fileId)).setter(CreatePresignedUrlResponse.setter(Builder::fileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileId").build()}).build();
    private static final SdkField<String> PRESIGNED_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("presignedUrl").getter(CreatePresignedUrlResponse.getter(CreatePresignedUrlResponse::presignedUrl)).setter(CreatePresignedUrlResponse.setter(Builder::presignedUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedUrl").build()}).build();
    private static final SdkField<Map<String, String>> PRESIGNED_URL_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("presignedUrlFields").getter(CreatePresignedUrlResponse.getter(CreatePresignedUrlResponse::presignedUrlFields)).setter(CreatePresignedUrlResponse.setter(Builder::presignedUrlFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedUrlFields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> PRESIGNED_URL_EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("presignedUrlExpiration").getter(CreatePresignedUrlResponse.getter(CreatePresignedUrlResponse::presignedUrlExpiration)).setter(CreatePresignedUrlResponse.setter(Builder::presignedUrlExpiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedUrlExpiration").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_ID_FIELD, PRESIGNED_URL_FIELD, PRESIGNED_URL_FIELDS_FIELD, PRESIGNED_URL_EXPIRATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePresignedUrlResponse.memberNameToFieldInitializer();
    private final String fileId;
    private final String presignedUrl;
    private final Map<String, String> presignedUrlFields;
    private final Instant presignedUrlExpiration;

    private CreatePresignedUrlResponse(BuilderImpl builder) {
        super(builder);
        this.fileId = builder.fileId;
        this.presignedUrl = builder.presignedUrl;
        this.presignedUrlFields = builder.presignedUrlFields;
        this.presignedUrlExpiration = builder.presignedUrlExpiration;
    }

    public final String fileId() {
        return this.fileId;
    }

    public final String presignedUrl() {
        return this.presignedUrl;
    }

    public final boolean hasPresignedUrlFields() {
        return this.presignedUrlFields != null && !(this.presignedUrlFields instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> presignedUrlFields() {
        return this.presignedUrlFields;
    }

    public final Instant presignedUrlExpiration() {
        return this.presignedUrlExpiration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.presignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPresignedUrlFields() ? this.presignedUrlFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.presignedUrlExpiration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresignedUrlResponse)) {
            return false;
        }
        CreatePresignedUrlResponse other = (CreatePresignedUrlResponse)((Object)obj);
        return Objects.equals(this.fileId(), other.fileId()) && Objects.equals(this.presignedUrl(), other.presignedUrl()) && this.hasPresignedUrlFields() == other.hasPresignedUrlFields() && Objects.equals(this.presignedUrlFields(), other.presignedUrlFields()) && Objects.equals(this.presignedUrlExpiration(), other.presignedUrlExpiration());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePresignedUrlResponse").add("FileId", (Object)this.fileId()).add("PresignedUrl", (Object)this.presignedUrl()).add("PresignedUrlFields", this.hasPresignedUrlFields() ? this.presignedUrlFields() : null).add("PresignedUrlExpiration", (Object)this.presignedUrlExpiration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileId": {
                return Optional.ofNullable(clazz.cast(this.fileId()));
            }
            case "presignedUrl": {
                return Optional.ofNullable(clazz.cast(this.presignedUrl()));
            }
            case "presignedUrlFields": {
                return Optional.ofNullable(clazz.cast(this.presignedUrlFields()));
            }
            case "presignedUrlExpiration": {
                return Optional.ofNullable(clazz.cast(this.presignedUrlExpiration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fileId", FILE_ID_FIELD);
        map.put("presignedUrl", PRESIGNED_URL_FIELD);
        map.put("presignedUrlFields", PRESIGNED_URL_FIELDS_FIELD);
        map.put("presignedUrlExpiration", PRESIGNED_URL_EXPIRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePresignedUrlResponse, T> g) {
        return obj -> g.apply((CreatePresignedUrlResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsResponse.BuilderImpl
    implements Builder {
        private String fileId;
        private String presignedUrl;
        private Map<String, String> presignedUrlFields = DefaultSdkAutoConstructMap.getInstance();
        private Instant presignedUrlExpiration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresignedUrlResponse model) {
            super(model);
            this.fileId(model.fileId);
            this.presignedUrl(model.presignedUrl);
            this.presignedUrlFields(model.presignedUrlFields);
            this.presignedUrlExpiration(model.presignedUrlExpiration);
        }

        public final String getFileId() {
            return this.fileId;
        }

        public final void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public final Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public final String getPresignedUrl() {
            return this.presignedUrl;
        }

        public final void setPresignedUrl(String presignedUrl) {
            this.presignedUrl = presignedUrl;
        }

        @Override
        public final Builder presignedUrl(String presignedUrl) {
            this.presignedUrl = presignedUrl;
            return this;
        }

        public final Map<String, String> getPresignedUrlFields() {
            if (this.presignedUrlFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.presignedUrlFields;
        }

        public final void setPresignedUrlFields(Map<String, String> presignedUrlFields) {
            this.presignedUrlFields = PresignedUrlFieldsCopier.copy(presignedUrlFields);
        }

        @Override
        public final Builder presignedUrlFields(Map<String, String> presignedUrlFields) {
            this.presignedUrlFields = PresignedUrlFieldsCopier.copy(presignedUrlFields);
            return this;
        }

        public final Instant getPresignedUrlExpiration() {
            return this.presignedUrlExpiration;
        }

        public final void setPresignedUrlExpiration(Instant presignedUrlExpiration) {
            this.presignedUrlExpiration = presignedUrlExpiration;
        }

        @Override
        public final Builder presignedUrlExpiration(Instant presignedUrlExpiration) {
            this.presignedUrlExpiration = presignedUrlExpiration;
            return this;
        }

        @Override
        public CreatePresignedUrlResponse build() {
            return new CreatePresignedUrlResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QAppsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePresignedUrlResponse> {
        public Builder fileId(String var1);

        public Builder presignedUrl(String var1);

        public Builder presignedUrlFields(Map<String, String> var1);

        public Builder presignedUrlExpiration(Instant var1);
    }
}

