/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, CreateApplicationResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(CreateApplicationResponse.getter(CreateApplicationResponse::applicationId)).setter(CreateApplicationResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationArn").getter(CreateApplicationResponse.getter(CreateApplicationResponse::applicationArn)).setter(CreateApplicationResponse.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, APPLICATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateApplicationResponse.memberNameToFieldInitializer();
    private final String applicationId;
    private final String applicationArn;

    private CreateApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.applicationArn = builder.applicationArn;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationResponse)) {
            return false;
        }
        CreateApplicationResponse other = (CreateApplicationResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.applicationArn(), other.applicationArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationResponse").add("ApplicationId", (Object)this.applicationId()).add("ApplicationArn", (Object)this.applicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "applicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("applicationArn", APPLICATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationResponse, T> g) {
        return obj -> g.apply((CreateApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String applicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.applicationArn(model.applicationArn);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        @Override
        public CreateApplicationResponse build() {
            return new CreateApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationResponse> {
        public Builder applicationId(String var1);

        public Builder applicationArn(String var1);
    }
}

