/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.AudioExtractionConfiguration;
import software.amazon.awssdk.services.qbusiness.model.ImageExtractionConfiguration;
import software.amazon.awssdk.services.qbusiness.model.VideoExtractionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaExtractionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaExtractionConfiguration> {
    private static final SdkField<ImageExtractionConfiguration> IMAGE_EXTRACTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageExtractionConfiguration").getter(MediaExtractionConfiguration.getter(MediaExtractionConfiguration::imageExtractionConfiguration)).setter(MediaExtractionConfiguration.setter(Builder::imageExtractionConfiguration)).constructor(ImageExtractionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageExtractionConfiguration").build()}).build();
    private static final SdkField<AudioExtractionConfiguration> AUDIO_EXTRACTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("audioExtractionConfiguration").getter(MediaExtractionConfiguration.getter(MediaExtractionConfiguration::audioExtractionConfiguration)).setter(MediaExtractionConfiguration.setter(Builder::audioExtractionConfiguration)).constructor(AudioExtractionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioExtractionConfiguration").build()}).build();
    private static final SdkField<VideoExtractionConfiguration> VIDEO_EXTRACTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("videoExtractionConfiguration").getter(MediaExtractionConfiguration.getter(MediaExtractionConfiguration::videoExtractionConfiguration)).setter(MediaExtractionConfiguration.setter(Builder::videoExtractionConfiguration)).constructor(VideoExtractionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoExtractionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_EXTRACTION_CONFIGURATION_FIELD, AUDIO_EXTRACTION_CONFIGURATION_FIELD, VIDEO_EXTRACTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaExtractionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ImageExtractionConfiguration imageExtractionConfiguration;
    private final AudioExtractionConfiguration audioExtractionConfiguration;
    private final VideoExtractionConfiguration videoExtractionConfiguration;

    private MediaExtractionConfiguration(BuilderImpl builder) {
        this.imageExtractionConfiguration = builder.imageExtractionConfiguration;
        this.audioExtractionConfiguration = builder.audioExtractionConfiguration;
        this.videoExtractionConfiguration = builder.videoExtractionConfiguration;
    }

    public final ImageExtractionConfiguration imageExtractionConfiguration() {
        return this.imageExtractionConfiguration;
    }

    public final AudioExtractionConfiguration audioExtractionConfiguration() {
        return this.audioExtractionConfiguration;
    }

    public final VideoExtractionConfiguration videoExtractionConfiguration() {
        return this.videoExtractionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageExtractionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioExtractionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoExtractionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaExtractionConfiguration)) {
            return false;
        }
        MediaExtractionConfiguration other = (MediaExtractionConfiguration)obj;
        return Objects.equals(this.imageExtractionConfiguration(), other.imageExtractionConfiguration()) && Objects.equals(this.audioExtractionConfiguration(), other.audioExtractionConfiguration()) && Objects.equals(this.videoExtractionConfiguration(), other.videoExtractionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"MediaExtractionConfiguration").add("ImageExtractionConfiguration", (Object)this.imageExtractionConfiguration()).add("AudioExtractionConfiguration", (Object)this.audioExtractionConfiguration()).add("VideoExtractionConfiguration", (Object)this.videoExtractionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageExtractionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageExtractionConfiguration()));
            }
            case "audioExtractionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.audioExtractionConfiguration()));
            }
            case "videoExtractionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.videoExtractionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("imageExtractionConfiguration", IMAGE_EXTRACTION_CONFIGURATION_FIELD);
        map.put("audioExtractionConfiguration", AUDIO_EXTRACTION_CONFIGURATION_FIELD);
        map.put("videoExtractionConfiguration", VIDEO_EXTRACTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaExtractionConfiguration, T> g) {
        return obj -> g.apply((MediaExtractionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ImageExtractionConfiguration imageExtractionConfiguration;
        private AudioExtractionConfiguration audioExtractionConfiguration;
        private VideoExtractionConfiguration videoExtractionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaExtractionConfiguration model) {
            this.imageExtractionConfiguration(model.imageExtractionConfiguration);
            this.audioExtractionConfiguration(model.audioExtractionConfiguration);
            this.videoExtractionConfiguration(model.videoExtractionConfiguration);
        }

        public final ImageExtractionConfiguration.Builder getImageExtractionConfiguration() {
            return this.imageExtractionConfiguration != null ? this.imageExtractionConfiguration.toBuilder() : null;
        }

        public final void setImageExtractionConfiguration(ImageExtractionConfiguration.BuilderImpl imageExtractionConfiguration) {
            this.imageExtractionConfiguration = imageExtractionConfiguration != null ? imageExtractionConfiguration.build() : null;
        }

        @Override
        public final Builder imageExtractionConfiguration(ImageExtractionConfiguration imageExtractionConfiguration) {
            this.imageExtractionConfiguration = imageExtractionConfiguration;
            return this;
        }

        public final AudioExtractionConfiguration.Builder getAudioExtractionConfiguration() {
            return this.audioExtractionConfiguration != null ? this.audioExtractionConfiguration.toBuilder() : null;
        }

        public final void setAudioExtractionConfiguration(AudioExtractionConfiguration.BuilderImpl audioExtractionConfiguration) {
            this.audioExtractionConfiguration = audioExtractionConfiguration != null ? audioExtractionConfiguration.build() : null;
        }

        @Override
        public final Builder audioExtractionConfiguration(AudioExtractionConfiguration audioExtractionConfiguration) {
            this.audioExtractionConfiguration = audioExtractionConfiguration;
            return this;
        }

        public final VideoExtractionConfiguration.Builder getVideoExtractionConfiguration() {
            return this.videoExtractionConfiguration != null ? this.videoExtractionConfiguration.toBuilder() : null;
        }

        public final void setVideoExtractionConfiguration(VideoExtractionConfiguration.BuilderImpl videoExtractionConfiguration) {
            this.videoExtractionConfiguration = videoExtractionConfiguration != null ? videoExtractionConfiguration.build() : null;
        }

        @Override
        public final Builder videoExtractionConfiguration(VideoExtractionConfiguration videoExtractionConfiguration) {
            this.videoExtractionConfiguration = videoExtractionConfiguration;
            return this;
        }

        public MediaExtractionConfiguration build() {
            return new MediaExtractionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaExtractionConfiguration> {
        public Builder imageExtractionConfiguration(ImageExtractionConfiguration var1);

        default public Builder imageExtractionConfiguration(Consumer<ImageExtractionConfiguration.Builder> imageExtractionConfiguration) {
            return this.imageExtractionConfiguration((ImageExtractionConfiguration)((ImageExtractionConfiguration.Builder)ImageExtractionConfiguration.builder().applyMutation(imageExtractionConfiguration)).build());
        }

        public Builder audioExtractionConfiguration(AudioExtractionConfiguration var1);

        default public Builder audioExtractionConfiguration(Consumer<AudioExtractionConfiguration.Builder> audioExtractionConfiguration) {
            return this.audioExtractionConfiguration((AudioExtractionConfiguration)((AudioExtractionConfiguration.Builder)AudioExtractionConfiguration.builder().applyMutation(audioExtractionConfiguration)).build());
        }

        public Builder videoExtractionConfiguration(VideoExtractionConfiguration var1);

        default public Builder videoExtractionConfiguration(Consumer<VideoExtractionConfiguration.Builder> videoExtractionConfiguration) {
            return this.videoExtractionConfiguration((VideoExtractionConfiguration)((VideoExtractionConfiguration.Builder)VideoExtractionConfiguration.builder().applyMutation(videoExtractionConfiguration)).build());
        }
    }
}

