/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessAsyncClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.RelevantContent;
import software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentRequest;
import software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentResponse;

public class SearchRelevantContentPublisher
implements SdkPublisher<SearchRelevantContentResponse> {
    private final QBusinessAsyncClient client;
    private final SearchRelevantContentRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchRelevantContentPublisher(QBusinessAsyncClient client, SearchRelevantContentRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchRelevantContentPublisher(QBusinessAsyncClient client, SearchRelevantContentRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchRelevantContentResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchRelevantContentResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RelevantContent> relevantContent() {
        Function<SearchRelevantContentResponse, Iterator> getIterator = response -> {
            if (response != null && response.relevantContent() != null) {
                return response.relevantContent().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchRelevantContentResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchRelevantContentResponseFetcher
    implements AsyncPageFetcher<SearchRelevantContentResponse> {
        private SearchRelevantContentResponseFetcher() {
        }

        public boolean hasNextPage(SearchRelevantContentResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchRelevantContentResponse> nextPage(SearchRelevantContentResponse previousPage) {
            if (previousPage == null) {
                return SearchRelevantContentPublisher.this.client.searchRelevantContent(SearchRelevantContentPublisher.this.firstRequest);
            }
            return SearchRelevantContentPublisher.this.client.searchRelevantContent((SearchRelevantContentRequest)((Object)SearchRelevantContentPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

