/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributeCondition;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributeTarget;
import software.amazon.awssdk.services.qbusiness.model.DocumentContentOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InlineDocumentEnrichmentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InlineDocumentEnrichmentConfiguration> {
    private static final SdkField<DocumentAttributeCondition> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("condition").getter(InlineDocumentEnrichmentConfiguration.getter(InlineDocumentEnrichmentConfiguration::condition)).setter(InlineDocumentEnrichmentConfiguration.setter(Builder::condition)).constructor(DocumentAttributeCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()}).build();
    private static final SdkField<DocumentAttributeTarget> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("target").getter(InlineDocumentEnrichmentConfiguration.getter(InlineDocumentEnrichmentConfiguration::target)).setter(InlineDocumentEnrichmentConfiguration.setter(Builder::target)).constructor(DocumentAttributeTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<String> DOCUMENT_CONTENT_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentContentOperator").getter(InlineDocumentEnrichmentConfiguration.getter(InlineDocumentEnrichmentConfiguration::documentContentOperatorAsString)).setter(InlineDocumentEnrichmentConfiguration.setter(Builder::documentContentOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentContentOperator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_FIELD, TARGET_FIELD, DOCUMENT_CONTENT_OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InlineDocumentEnrichmentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DocumentAttributeCondition condition;
    private final DocumentAttributeTarget target;
    private final String documentContentOperator;

    private InlineDocumentEnrichmentConfiguration(BuilderImpl builder) {
        this.condition = builder.condition;
        this.target = builder.target;
        this.documentContentOperator = builder.documentContentOperator;
    }

    public final DocumentAttributeCondition condition() {
        return this.condition;
    }

    public final DocumentAttributeTarget target() {
        return this.target;
    }

    public final DocumentContentOperator documentContentOperator() {
        return DocumentContentOperator.fromValue(this.documentContentOperator);
    }

    public final String documentContentOperatorAsString() {
        return this.documentContentOperator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentContentOperatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineDocumentEnrichmentConfiguration)) {
            return false;
        }
        InlineDocumentEnrichmentConfiguration other = (InlineDocumentEnrichmentConfiguration)obj;
        return Objects.equals(this.condition(), other.condition()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.documentContentOperatorAsString(), other.documentContentOperatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InlineDocumentEnrichmentConfiguration").add("Condition", (Object)this.condition()).add("Target", (Object)this.target()).add("DocumentContentOperator", (Object)this.documentContentOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "documentContentOperator": {
                return Optional.ofNullable(clazz.cast(this.documentContentOperatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("condition", CONDITION_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("documentContentOperator", DOCUMENT_CONTENT_OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InlineDocumentEnrichmentConfiguration, T> g) {
        return obj -> g.apply((InlineDocumentEnrichmentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DocumentAttributeCondition condition;
        private DocumentAttributeTarget target;
        private String documentContentOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(InlineDocumentEnrichmentConfiguration model) {
            this.condition(model.condition);
            this.target(model.target);
            this.documentContentOperator(model.documentContentOperator);
        }

        public final DocumentAttributeCondition.Builder getCondition() {
            return this.condition != null ? this.condition.toBuilder() : null;
        }

        public final void setCondition(DocumentAttributeCondition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        public final Builder condition(DocumentAttributeCondition condition) {
            this.condition = condition;
            return this;
        }

        public final DocumentAttributeTarget.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(DocumentAttributeTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(DocumentAttributeTarget target) {
            this.target = target;
            return this;
        }

        public final String getDocumentContentOperator() {
            return this.documentContentOperator;
        }

        public final void setDocumentContentOperator(String documentContentOperator) {
            this.documentContentOperator = documentContentOperator;
        }

        @Override
        public final Builder documentContentOperator(String documentContentOperator) {
            this.documentContentOperator = documentContentOperator;
            return this;
        }

        @Override
        public final Builder documentContentOperator(DocumentContentOperator documentContentOperator) {
            this.documentContentOperator(documentContentOperator == null ? null : documentContentOperator.toString());
            return this;
        }

        public InlineDocumentEnrichmentConfiguration build() {
            return new InlineDocumentEnrichmentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InlineDocumentEnrichmentConfiguration> {
        public Builder condition(DocumentAttributeCondition var1);

        default public Builder condition(Consumer<DocumentAttributeCondition.Builder> condition) {
            return this.condition((DocumentAttributeCondition)((DocumentAttributeCondition.Builder)DocumentAttributeCondition.builder().applyMutation(condition)).build());
        }

        public Builder target(DocumentAttributeTarget var1);

        default public Builder target(Consumer<DocumentAttributeTarget.Builder> target) {
            return this.target((DocumentAttributeTarget)((DocumentAttributeTarget.Builder)DocumentAttributeTarget.builder().applyMutation(target)).build());
        }

        public Builder documentContentOperator(String var1);

        public Builder documentContentOperator(DocumentContentOperator var1);
    }
}

