/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessAsyncClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ActionSummary;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsResponse;

public class ListPluginTypeActionsPublisher
implements SdkPublisher<ListPluginTypeActionsResponse> {
    private final QBusinessAsyncClient client;
    private final ListPluginTypeActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPluginTypeActionsPublisher(QBusinessAsyncClient client, ListPluginTypeActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPluginTypeActionsPublisher(QBusinessAsyncClient client, ListPluginTypeActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPluginTypeActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPluginTypeActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActionSummary> items() {
        Function<ListPluginTypeActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPluginTypeActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPluginTypeActionsResponseFetcher
    implements AsyncPageFetcher<ListPluginTypeActionsResponse> {
        private ListPluginTypeActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPluginTypeActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPluginTypeActionsResponse> nextPage(ListPluginTypeActionsResponse previousPage) {
            if (previousPage == null) {
                return ListPluginTypeActionsPublisher.this.client.listPluginTypeActions(ListPluginTypeActionsPublisher.this.firstRequest);
            }
            return ListPluginTypeActionsPublisher.this.client.listPluginTypeActions((ListPluginTypeActionsRequest)((Object)ListPluginTypeActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

