/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.ChatResponseConfigurationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChatResponseConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChatResponseConfiguration> {
    private static final SdkField<String> CHAT_RESPONSE_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("chatResponseConfigurationId").getter(ChatResponseConfiguration.getter(ChatResponseConfiguration::chatResponseConfigurationId)).setter(ChatResponseConfiguration.setter(Builder::chatResponseConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatResponseConfigurationId").build()}).build();
    private static final SdkField<String> CHAT_RESPONSE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("chatResponseConfigurationArn").getter(ChatResponseConfiguration.getter(ChatResponseConfiguration::chatResponseConfigurationArn)).setter(ChatResponseConfiguration.setter(Builder::chatResponseConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatResponseConfigurationArn").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(ChatResponseConfiguration.getter(ChatResponseConfiguration::displayName)).setter(ChatResponseConfiguration.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> RESPONSE_CONFIGURATION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseConfigurationSummary").getter(ChatResponseConfiguration.getter(ChatResponseConfiguration::responseConfigurationSummary)).setter(ChatResponseConfiguration.setter(Builder::responseConfigurationSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseConfigurationSummary").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ChatResponseConfiguration.getter(ChatResponseConfiguration::statusAsString)).setter(ChatResponseConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ChatResponseConfiguration.getter(ChatResponseConfiguration::createdAt)).setter(ChatResponseConfiguration.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(ChatResponseConfiguration.getter(ChatResponseConfiguration::updatedAt)).setter(ChatResponseConfiguration.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAT_RESPONSE_CONFIGURATION_ID_FIELD, CHAT_RESPONSE_CONFIGURATION_ARN_FIELD, DISPLAY_NAME_FIELD, RESPONSE_CONFIGURATION_SUMMARY_FIELD, STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChatResponseConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String chatResponseConfigurationId;
    private final String chatResponseConfigurationArn;
    private final String displayName;
    private final String responseConfigurationSummary;
    private final String status;
    private final Instant createdAt;
    private final Instant updatedAt;

    private ChatResponseConfiguration(BuilderImpl builder) {
        this.chatResponseConfigurationId = builder.chatResponseConfigurationId;
        this.chatResponseConfigurationArn = builder.chatResponseConfigurationArn;
        this.displayName = builder.displayName;
        this.responseConfigurationSummary = builder.responseConfigurationSummary;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String chatResponseConfigurationId() {
        return this.chatResponseConfigurationId;
    }

    public final String chatResponseConfigurationArn() {
        return this.chatResponseConfigurationArn;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String responseConfigurationSummary() {
        return this.responseConfigurationSummary;
    }

    public final ChatResponseConfigurationStatus status() {
        return ChatResponseConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.chatResponseConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.chatResponseConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseConfigurationSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatResponseConfiguration)) {
            return false;
        }
        ChatResponseConfiguration other = (ChatResponseConfiguration)obj;
        return Objects.equals(this.chatResponseConfigurationId(), other.chatResponseConfigurationId()) && Objects.equals(this.chatResponseConfigurationArn(), other.chatResponseConfigurationArn()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.responseConfigurationSummary(), other.responseConfigurationSummary()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ChatResponseConfiguration").add("ChatResponseConfigurationId", (Object)this.chatResponseConfigurationId()).add("ChatResponseConfigurationArn", (Object)this.chatResponseConfigurationArn()).add("DisplayName", (Object)this.displayName()).add("ResponseConfigurationSummary", (Object)this.responseConfigurationSummary()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "chatResponseConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.chatResponseConfigurationId()));
            }
            case "chatResponseConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.chatResponseConfigurationArn()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "responseConfigurationSummary": {
                return Optional.ofNullable(clazz.cast(this.responseConfigurationSummary()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("chatResponseConfigurationId", CHAT_RESPONSE_CONFIGURATION_ID_FIELD);
        map.put("chatResponseConfigurationArn", CHAT_RESPONSE_CONFIGURATION_ARN_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("responseConfigurationSummary", RESPONSE_CONFIGURATION_SUMMARY_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatResponseConfiguration, T> g) {
        return obj -> g.apply((ChatResponseConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String chatResponseConfigurationId;
        private String chatResponseConfigurationArn;
        private String displayName;
        private String responseConfigurationSummary;
        private String status;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatResponseConfiguration model) {
            this.chatResponseConfigurationId(model.chatResponseConfigurationId);
            this.chatResponseConfigurationArn(model.chatResponseConfigurationArn);
            this.displayName(model.displayName);
            this.responseConfigurationSummary(model.responseConfigurationSummary);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getChatResponseConfigurationId() {
            return this.chatResponseConfigurationId;
        }

        public final void setChatResponseConfigurationId(String chatResponseConfigurationId) {
            this.chatResponseConfigurationId = chatResponseConfigurationId;
        }

        @Override
        public final Builder chatResponseConfigurationId(String chatResponseConfigurationId) {
            this.chatResponseConfigurationId = chatResponseConfigurationId;
            return this;
        }

        public final String getChatResponseConfigurationArn() {
            return this.chatResponseConfigurationArn;
        }

        public final void setChatResponseConfigurationArn(String chatResponseConfigurationArn) {
            this.chatResponseConfigurationArn = chatResponseConfigurationArn;
        }

        @Override
        public final Builder chatResponseConfigurationArn(String chatResponseConfigurationArn) {
            this.chatResponseConfigurationArn = chatResponseConfigurationArn;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getResponseConfigurationSummary() {
            return this.responseConfigurationSummary;
        }

        public final void setResponseConfigurationSummary(String responseConfigurationSummary) {
            this.responseConfigurationSummary = responseConfigurationSummary;
        }

        @Override
        public final Builder responseConfigurationSummary(String responseConfigurationSummary) {
            this.responseConfigurationSummary = responseConfigurationSummary;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChatResponseConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public ChatResponseConfiguration build() {
            return new ChatResponseConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChatResponseConfiguration> {
        public Builder chatResponseConfigurationId(String var1);

        public Builder chatResponseConfigurationArn(String var1);

        public Builder displayName(String var1);

        public Builder responseConfigurationSummary(String var1);

        public Builder status(String var1);

        public Builder status(ChatResponseConfigurationStatus var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

