/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler;
import software.amazon.awssdk.services.qbusiness.model.ActionReviewEvent;
import software.amazon.awssdk.services.qbusiness.model.AuthChallengeRequestEvent;
import software.amazon.awssdk.services.qbusiness.model.ChatOutputStream;
import software.amazon.awssdk.services.qbusiness.model.ChatResponse;
import software.amazon.awssdk.services.qbusiness.model.DefaultChatResponseHandlerBuilder;
import software.amazon.awssdk.services.qbusiness.model.DefaultChatVisitorBuilder;
import software.amazon.awssdk.services.qbusiness.model.FailedAttachmentEvent;
import software.amazon.awssdk.services.qbusiness.model.MetadataEvent;
import software.amazon.awssdk.services.qbusiness.model.TextOutputEvent;

@SdkPublicApi
public interface ChatResponseHandler
extends EventStreamResponseHandler<ChatResponse, ChatOutputStream> {
    public static Builder builder() {
        return new DefaultChatResponseHandlerBuilder();
    }

    public static interface Visitor {
        public static Builder builder() {
            return new DefaultChatVisitorBuilder();
        }

        default public void visitDefault(ChatOutputStream event) {
        }

        default public void visitTextEvent(TextOutputEvent event) {
            this.visitDefault(event);
        }

        default public void visitMetadataEvent(MetadataEvent event) {
            this.visitDefault(event);
        }

        default public void visitActionReviewEvent(ActionReviewEvent event) {
            this.visitDefault(event);
        }

        default public void visitFailedAttachmentEvent(FailedAttachmentEvent event) {
            this.visitDefault(event);
        }

        default public void visitAuthChallengeRequestEvent(AuthChallengeRequestEvent event) {
            this.visitDefault(event);
        }

        public static interface Builder {
            public Builder onDefault(Consumer<ChatOutputStream> var1);

            public Visitor build();

            public Builder onTextEvent(Consumer<TextOutputEvent> var1);

            public Builder onMetadataEvent(Consumer<MetadataEvent> var1);

            public Builder onActionReviewEvent(Consumer<ActionReviewEvent> var1);

            public Builder onFailedAttachmentEvent(Consumer<FailedAttachmentEvent> var1);

            public Builder onAuthChallengeRequestEvent(Consumer<AuthChallengeRequestEvent> var1);
        }
    }

    public static interface Builder
    extends EventStreamResponseHandler.Builder<ChatResponse, ChatOutputStream, Builder> {
        public Builder subscriber(Visitor var1);

        public ChatResponseHandler build();
    }
}

