/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ErrorCode {
    INTERNAL_ERROR("InternalError"),
    INVALID_REQUEST("InvalidRequest"),
    RESOURCE_INACTIVE("ResourceInactive"),
    RESOURCE_NOT_FOUND("ResourceNotFound"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorCode> VALUE_MAP;
    private final String value;

    private ErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCode> knownValues() {
        EnumSet<ErrorCode> knownValues = EnumSet.allOf(ErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ErrorCode.class, ErrorCode::toString);
    }
}

