/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RetrieverType {
    NATIVE_INDEX("NATIVE_INDEX"),
    KENDRA_INDEX("KENDRA_INDEX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RetrieverType> VALUE_MAP;
    private final String value;

    private RetrieverType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RetrieverType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RetrieverType> knownValues() {
        EnumSet<RetrieverType> knownValues = EnumSet.allOf(RetrieverType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RetrieverType.class, RetrieverType::toString);
    }
}

