/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.S3;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentContent> {
    private static final SdkField<SdkBytes> BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("blob").getter(DocumentContent.getter(DocumentContent::blob)).setter(DocumentContent.setter(Builder::blob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blob").build()}).build();
    private static final SdkField<S3> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(DocumentContent.getter(DocumentContent::s3)).setter(DocumentContent.setter(Builder::s3)).constructor(S3::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOB_FIELD, S3_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SdkBytes blob;
    private final S3 s3;
    private final Type type;

    private DocumentContent(BuilderImpl builder) {
        this.blob = builder.blob;
        this.s3 = builder.s3;
        this.type = builder.type;
    }

    public final SdkBytes blob() {
        return this.blob;
    }

    public final S3 s3() {
        return this.s3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blob());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentContent)) {
            return false;
        }
        DocumentContent other = (DocumentContent)obj;
        return Objects.equals(this.blob(), other.blob()) && Objects.equals(this.s3(), other.s3());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentContent").add("Blob", (Object)this.blob()).add("S3", (Object)this.s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blob": {
                return Optional.ofNullable(clazz.cast(this.blob()));
            }
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
        }
        return Optional.empty();
    }

    public static DocumentContent fromBlob(SdkBytes blob) {
        return (DocumentContent)DocumentContent.builder().blob(blob).build();
    }

    public static DocumentContent fromS3(S3 s3) {
        return (DocumentContent)DocumentContent.builder().s3(s3).build();
    }

    public static DocumentContent fromS3(Consumer<S3.Builder> s3) {
        S3.Builder builder = S3.builder();
        s3.accept(builder);
        return DocumentContent.fromS3((S3)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("blob", BLOB_FIELD);
        map.put("s3", S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentContent, T> g) {
        return obj -> g.apply((DocumentContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BLOB,
        S3,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes blob;
        private S3 s3;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentContent model) {
            this.blob(model.blob);
            this.s3(model.s3);
        }

        public final ByteBuffer getBlob() {
            return this.blob == null ? null : this.blob.asByteBuffer();
        }

        public final void setBlob(ByteBuffer blob) {
            this.blob(blob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)blob));
        }

        @Override
        public final Builder blob(SdkBytes blob) {
            SdkBytes oldValue = this.blob;
            this.blob = blob;
            this.handleUnionValueChange(Type.BLOB, oldValue, this.blob);
            return this;
        }

        public final S3.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3.BuilderImpl s3) {
            S3 oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(S3 s3) {
            S3 oldValue = this.s3;
            this.s3 = s3;
            this.handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        public DocumentContent build() {
            return new DocumentContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentContent> {
        public Builder blob(SdkBytes var1);

        public Builder s3(S3 var1);

        default public Builder s3(Consumer<S3.Builder> s3) {
            return this.s3((S3)((S3.Builder)S3.builder().applyMutation(s3)).build());
        }
    }
}

