/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.ContentBlockerRule;
import software.amazon.awssdk.services.qbusiness.model.ContentRetrievalRule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleConfiguration> {
    private static final SdkField<ContentBlockerRule> CONTENT_BLOCKER_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contentBlockerRule").getter(RuleConfiguration.getter(RuleConfiguration::contentBlockerRule)).setter(RuleConfiguration.setter(Builder::contentBlockerRule)).constructor(ContentBlockerRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentBlockerRule").build()}).build();
    private static final SdkField<ContentRetrievalRule> CONTENT_RETRIEVAL_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contentRetrievalRule").getter(RuleConfiguration.getter(RuleConfiguration::contentRetrievalRule)).setter(RuleConfiguration.setter(Builder::contentRetrievalRule)).constructor(ContentRetrievalRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentRetrievalRule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_BLOCKER_RULE_FIELD, CONTENT_RETRIEVAL_RULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ContentBlockerRule contentBlockerRule;
    private final ContentRetrievalRule contentRetrievalRule;
    private final Type type;

    private RuleConfiguration(BuilderImpl builder) {
        this.contentBlockerRule = builder.contentBlockerRule;
        this.contentRetrievalRule = builder.contentRetrievalRule;
        this.type = builder.type;
    }

    public final ContentBlockerRule contentBlockerRule() {
        return this.contentBlockerRule;
    }

    public final ContentRetrievalRule contentRetrievalRule() {
        return this.contentRetrievalRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentBlockerRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRetrievalRule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleConfiguration)) {
            return false;
        }
        RuleConfiguration other = (RuleConfiguration)obj;
        return Objects.equals(this.contentBlockerRule(), other.contentBlockerRule()) && Objects.equals(this.contentRetrievalRule(), other.contentRetrievalRule());
    }

    public final String toString() {
        return ToString.builder((String)"RuleConfiguration").add("ContentBlockerRule", (Object)this.contentBlockerRule()).add("ContentRetrievalRule", (Object)this.contentRetrievalRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentBlockerRule": {
                return Optional.ofNullable(clazz.cast(this.contentBlockerRule()));
            }
            case "contentRetrievalRule": {
                return Optional.ofNullable(clazz.cast(this.contentRetrievalRule()));
            }
        }
        return Optional.empty();
    }

    public static RuleConfiguration fromContentBlockerRule(ContentBlockerRule contentBlockerRule) {
        return (RuleConfiguration)RuleConfiguration.builder().contentBlockerRule(contentBlockerRule).build();
    }

    public static RuleConfiguration fromContentBlockerRule(Consumer<ContentBlockerRule.Builder> contentBlockerRule) {
        ContentBlockerRule.Builder builder = ContentBlockerRule.builder();
        contentBlockerRule.accept(builder);
        return RuleConfiguration.fromContentBlockerRule((ContentBlockerRule)builder.build());
    }

    public static RuleConfiguration fromContentRetrievalRule(ContentRetrievalRule contentRetrievalRule) {
        return (RuleConfiguration)RuleConfiguration.builder().contentRetrievalRule(contentRetrievalRule).build();
    }

    public static RuleConfiguration fromContentRetrievalRule(Consumer<ContentRetrievalRule.Builder> contentRetrievalRule) {
        ContentRetrievalRule.Builder builder = ContentRetrievalRule.builder();
        contentRetrievalRule.accept(builder);
        return RuleConfiguration.fromContentRetrievalRule((ContentRetrievalRule)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contentBlockerRule", CONTENT_BLOCKER_RULE_FIELD);
        map.put("contentRetrievalRule", CONTENT_RETRIEVAL_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleConfiguration, T> g) {
        return obj -> g.apply((RuleConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CONTENT_BLOCKER_RULE,
        CONTENT_RETRIEVAL_RULE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ContentBlockerRule contentBlockerRule;
        private ContentRetrievalRule contentRetrievalRule;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RuleConfiguration model) {
            this.contentBlockerRule(model.contentBlockerRule);
            this.contentRetrievalRule(model.contentRetrievalRule);
        }

        public final ContentBlockerRule.Builder getContentBlockerRule() {
            return this.contentBlockerRule != null ? this.contentBlockerRule.toBuilder() : null;
        }

        public final void setContentBlockerRule(ContentBlockerRule.BuilderImpl contentBlockerRule) {
            ContentBlockerRule oldValue = this.contentBlockerRule;
            this.contentBlockerRule = contentBlockerRule != null ? contentBlockerRule.build() : null;
            this.handleUnionValueChange(Type.CONTENT_BLOCKER_RULE, oldValue, this.contentBlockerRule);
        }

        @Override
        public final Builder contentBlockerRule(ContentBlockerRule contentBlockerRule) {
            ContentBlockerRule oldValue = this.contentBlockerRule;
            this.contentBlockerRule = contentBlockerRule;
            this.handleUnionValueChange(Type.CONTENT_BLOCKER_RULE, oldValue, this.contentBlockerRule);
            return this;
        }

        public final ContentRetrievalRule.Builder getContentRetrievalRule() {
            return this.contentRetrievalRule != null ? this.contentRetrievalRule.toBuilder() : null;
        }

        public final void setContentRetrievalRule(ContentRetrievalRule.BuilderImpl contentRetrievalRule) {
            ContentRetrievalRule oldValue = this.contentRetrievalRule;
            this.contentRetrievalRule = contentRetrievalRule != null ? contentRetrievalRule.build() : null;
            this.handleUnionValueChange(Type.CONTENT_RETRIEVAL_RULE, oldValue, this.contentRetrievalRule);
        }

        @Override
        public final Builder contentRetrievalRule(ContentRetrievalRule contentRetrievalRule) {
            ContentRetrievalRule oldValue = this.contentRetrievalRule;
            this.contentRetrievalRule = contentRetrievalRule;
            this.handleUnionValueChange(Type.CONTENT_RETRIEVAL_RULE, oldValue, this.contentRetrievalRule);
            return this;
        }

        public RuleConfiguration build() {
            return new RuleConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleConfiguration> {
        public Builder contentBlockerRule(ContentBlockerRule var1);

        default public Builder contentBlockerRule(Consumer<ContentBlockerRule.Builder> contentBlockerRule) {
            return this.contentBlockerRule((ContentBlockerRule)((ContentBlockerRule.Builder)ContentBlockerRule.builder().applyMutation(contentBlockerRule)).build());
        }

        public Builder contentRetrievalRule(ContentRetrievalRule var1);

        default public Builder contentRetrievalRule(Consumer<ContentRetrievalRule.Builder> contentRetrievalRule) {
            return this.contentRetrievalRule((ContentRetrievalRule)((ContentRetrievalRule.Builder)ContentRetrievalRule.builder().applyMutation(contentRetrievalRule)).build());
        }
    }
}

