/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.ObjectFieldsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppIntegrationsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppIntegrationsConfiguration> {
    private static final SdkField<String> APP_INTEGRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appIntegrationArn").getter(AppIntegrationsConfiguration.getter(AppIntegrationsConfiguration::appIntegrationArn)).setter(AppIntegrationsConfiguration.setter(Builder::appIntegrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appIntegrationArn").build()}).build();
    private static final SdkField<List<String>> OBJECT_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("objectFields").getter(AppIntegrationsConfiguration.getter(AppIntegrationsConfiguration::objectFields)).setter(AppIntegrationsConfiguration.setter(Builder::objectFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INTEGRATION_ARN_FIELD, OBJECT_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppIntegrationsConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String appIntegrationArn;
    private final List<String> objectFields;

    private AppIntegrationsConfiguration(BuilderImpl builder) {
        this.appIntegrationArn = builder.appIntegrationArn;
        this.objectFields = builder.objectFields;
    }

    public final String appIntegrationArn() {
        return this.appIntegrationArn;
    }

    public final boolean hasObjectFields() {
        return this.objectFields != null && !(this.objectFields instanceof SdkAutoConstructList);
    }

    public final List<String> objectFields() {
        return this.objectFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appIntegrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjectFields() ? this.objectFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppIntegrationsConfiguration)) {
            return false;
        }
        AppIntegrationsConfiguration other = (AppIntegrationsConfiguration)obj;
        return Objects.equals(this.appIntegrationArn(), other.appIntegrationArn()) && this.hasObjectFields() == other.hasObjectFields() && Objects.equals(this.objectFields(), other.objectFields());
    }

    public final String toString() {
        return ToString.builder((String)"AppIntegrationsConfiguration").add("AppIntegrationArn", (Object)this.appIntegrationArn()).add("ObjectFields", this.hasObjectFields() ? this.objectFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appIntegrationArn": {
                return Optional.ofNullable(clazz.cast(this.appIntegrationArn()));
            }
            case "objectFields": {
                return Optional.ofNullable(clazz.cast(this.objectFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appIntegrationArn", APP_INTEGRATION_ARN_FIELD);
        map.put("objectFields", OBJECT_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppIntegrationsConfiguration, T> g) {
        return obj -> g.apply((AppIntegrationsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appIntegrationArn;
        private List<String> objectFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppIntegrationsConfiguration model) {
            this.appIntegrationArn(model.appIntegrationArn);
            this.objectFields(model.objectFields);
        }

        public final String getAppIntegrationArn() {
            return this.appIntegrationArn;
        }

        public final void setAppIntegrationArn(String appIntegrationArn) {
            this.appIntegrationArn = appIntegrationArn;
        }

        @Override
        public final Builder appIntegrationArn(String appIntegrationArn) {
            this.appIntegrationArn = appIntegrationArn;
            return this;
        }

        public final Collection<String> getObjectFields() {
            if (this.objectFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.objectFields;
        }

        public final void setObjectFields(Collection<String> objectFields) {
            this.objectFields = ObjectFieldsListCopier.copy(objectFields);
        }

        @Override
        public final Builder objectFields(Collection<String> objectFields) {
            this.objectFields = ObjectFieldsListCopier.copy(objectFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectFields(String ... objectFields) {
            this.objectFields(Arrays.asList(objectFields));
            return this;
        }

        public AppIntegrationsConfiguration build() {
            return new AppIntegrationsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppIntegrationsConfiguration> {
        public Builder appIntegrationArn(String var1);

        public Builder objectFields(Collection<String> var1);

        public Builder objectFields(String ... var1);
    }
}

