/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.ChannelSubtype;
import software.amazon.awssdk.services.qconnect.model.GroupingConfiguration;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateAttachment;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateAttachmentListCopier;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateAttributeType;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateAttributeTypeListCopier;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateAttributes;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateContentProvider;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExtendedMessageTemplateData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExtendedMessageTemplateData> {
    private static final SdkField<List<MessageTemplateAttachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attachments").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::attachments)).setter(ExtendedMessageTemplateData.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTemplateAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributeTypes").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::attributeTypesAsStrings)).setter(ExtendedMessageTemplateData.setter(Builder::attributeTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANNEL_SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelSubtype").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::channelSubtypeAsString)).setter(ExtendedMessageTemplateData.setter(Builder::channelSubtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSubtype").build()}).build();
    private static final SdkField<MessageTemplateContentProvider> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::content)).setter(ExtendedMessageTemplateData.setter(Builder::content)).constructor(MessageTemplateContentProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::createdTime)).setter(ExtendedMessageTemplateData.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<MessageTemplateAttributes> DEFAULT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultAttributes").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::defaultAttributes)).setter(ExtendedMessageTemplateData.setter(Builder::defaultAttributes)).constructor(MessageTemplateAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAttributes").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::description)).setter(ExtendedMessageTemplateData.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<GroupingConfiguration> GROUPING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("groupingConfiguration").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::groupingConfiguration)).setter(ExtendedMessageTemplateData.setter(Builder::groupingConfiguration)).constructor(GroupingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingConfiguration").build()}).build();
    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isActive").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::isActive)).setter(ExtendedMessageTemplateData.setter(Builder::isActive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseArn").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::knowledgeBaseArn)).setter(ExtendedMessageTemplateData.setter(Builder::knowledgeBaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::knowledgeBaseId)).setter(ExtendedMessageTemplateData.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::language)).setter(ExtendedMessageTemplateData.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastModifiedBy").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::lastModifiedBy)).setter(ExtendedMessageTemplateData.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::lastModifiedTime)).setter(ExtendedMessageTemplateData.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> MESSAGE_TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageTemplateArn").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::messageTemplateArn)).setter(ExtendedMessageTemplateData.setter(Builder::messageTemplateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateArn").build()}).build();
    private static final SdkField<String> MESSAGE_TEMPLATE_CONTENT_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageTemplateContentSha256").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::messageTemplateContentSha256)).setter(ExtendedMessageTemplateData.setter(Builder::messageTemplateContentSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateContentSha256").build()}).build();
    private static final SdkField<String> MESSAGE_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageTemplateId").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::messageTemplateId)).setter(ExtendedMessageTemplateData.setter(Builder::messageTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageTemplateId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::name)).setter(ExtendedMessageTemplateData.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::tags)).setter(ExtendedMessageTemplateData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("versionNumber").getter(ExtendedMessageTemplateData.getter(ExtendedMessageTemplateData::versionNumber)).setter(ExtendedMessageTemplateData.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENTS_FIELD, ATTRIBUTE_TYPES_FIELD, CHANNEL_SUBTYPE_FIELD, CONTENT_FIELD, CREATED_TIME_FIELD, DEFAULT_ATTRIBUTES_FIELD, DESCRIPTION_FIELD, GROUPING_CONFIGURATION_FIELD, IS_ACTIVE_FIELD, KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD, LANGUAGE_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, MESSAGE_TEMPLATE_ARN_FIELD, MESSAGE_TEMPLATE_CONTENT_SHA256_FIELD, MESSAGE_TEMPLATE_ID_FIELD, NAME_FIELD, TAGS_FIELD, VERSION_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExtendedMessageTemplateData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<MessageTemplateAttachment> attachments;
    private final List<String> attributeTypes;
    private final String channelSubtype;
    private final MessageTemplateContentProvider content;
    private final Instant createdTime;
    private final MessageTemplateAttributes defaultAttributes;
    private final String description;
    private final GroupingConfiguration groupingConfiguration;
    private final Boolean isActive;
    private final String knowledgeBaseArn;
    private final String knowledgeBaseId;
    private final String language;
    private final String lastModifiedBy;
    private final Instant lastModifiedTime;
    private final String messageTemplateArn;
    private final String messageTemplateContentSha256;
    private final String messageTemplateId;
    private final String name;
    private final Map<String, String> tags;
    private final Long versionNumber;

    private ExtendedMessageTemplateData(BuilderImpl builder) {
        this.attachments = builder.attachments;
        this.attributeTypes = builder.attributeTypes;
        this.channelSubtype = builder.channelSubtype;
        this.content = builder.content;
        this.createdTime = builder.createdTime;
        this.defaultAttributes = builder.defaultAttributes;
        this.description = builder.description;
        this.groupingConfiguration = builder.groupingConfiguration;
        this.isActive = builder.isActive;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.language = builder.language;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.messageTemplateArn = builder.messageTemplateArn;
        this.messageTemplateContentSha256 = builder.messageTemplateContentSha256;
        this.messageTemplateId = builder.messageTemplateId;
        this.name = builder.name;
        this.tags = builder.tags;
        this.versionNumber = builder.versionNumber;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<MessageTemplateAttachment> attachments() {
        return this.attachments;
    }

    public final List<MessageTemplateAttributeType> attributeTypes() {
        return MessageTemplateAttributeTypeListCopier.copyStringToEnum(this.attributeTypes);
    }

    public final boolean hasAttributeTypes() {
        return this.attributeTypes != null && !(this.attributeTypes instanceof SdkAutoConstructList);
    }

    public final List<String> attributeTypesAsStrings() {
        return this.attributeTypes;
    }

    public final ChannelSubtype channelSubtype() {
        return ChannelSubtype.fromValue(this.channelSubtype);
    }

    public final String channelSubtypeAsString() {
        return this.channelSubtype;
    }

    public final MessageTemplateContentProvider content() {
        return this.content;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final MessageTemplateAttributes defaultAttributes() {
        return this.defaultAttributes;
    }

    public final String description() {
        return this.description;
    }

    public final GroupingConfiguration groupingConfiguration() {
        return this.groupingConfiguration;
    }

    public final Boolean isActive() {
        return this.isActive;
    }

    public final String knowledgeBaseArn() {
        return this.knowledgeBaseArn;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String language() {
        return this.language;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String messageTemplateArn() {
        return this.messageTemplateArn;
    }

    public final String messageTemplateContentSha256() {
        return this.messageTemplateContentSha256;
    }

    public final String messageTemplateId() {
        return this.messageTemplateId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeTypes() ? this.attributeTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.channelSubtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.isActive());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTemplateContentSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedMessageTemplateData)) {
            return false;
        }
        ExtendedMessageTemplateData other = (ExtendedMessageTemplateData)obj;
        return this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments()) && this.hasAttributeTypes() == other.hasAttributeTypes() && Objects.equals(this.attributeTypesAsStrings(), other.attributeTypesAsStrings()) && Objects.equals(this.channelSubtypeAsString(), other.channelSubtypeAsString()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.defaultAttributes(), other.defaultAttributes()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.groupingConfiguration(), other.groupingConfiguration()) && Objects.equals(this.isActive(), other.isActive()) && Objects.equals(this.knowledgeBaseArn(), other.knowledgeBaseArn()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.messageTemplateArn(), other.messageTemplateArn()) && Objects.equals(this.messageTemplateContentSha256(), other.messageTemplateContentSha256()) && Objects.equals(this.messageTemplateId(), other.messageTemplateId()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.versionNumber(), other.versionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"ExtendedMessageTemplateData").add("Attachments", this.hasAttachments() ? this.attachments() : null).add("AttributeTypes", this.hasAttributeTypes() ? this.attributeTypesAsStrings() : null).add("ChannelSubtype", (Object)this.channelSubtypeAsString()).add("Content", (Object)this.content()).add("CreatedTime", (Object)this.createdTime()).add("DefaultAttributes", (Object)this.defaultAttributes()).add("Description", (Object)this.description()).add("GroupingConfiguration", (Object)this.groupingConfiguration()).add("IsActive", (Object)this.isActive()).add("KnowledgeBaseArn", (Object)this.knowledgeBaseArn()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Language", (Object)this.language()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("MessageTemplateArn", (Object)this.messageTemplateArn()).add("MessageTemplateContentSha256", (Object)this.messageTemplateContentSha256()).add("MessageTemplateId", (Object)this.messageTemplateId()).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).add("VersionNumber", (Object)this.versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "attributeTypes": {
                return Optional.ofNullable(clazz.cast(this.attributeTypesAsStrings()));
            }
            case "channelSubtype": {
                return Optional.ofNullable(clazz.cast(this.channelSubtypeAsString()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "defaultAttributes": {
                return Optional.ofNullable(clazz.cast(this.defaultAttributes()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "groupingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.groupingConfiguration()));
            }
            case "isActive": {
                return Optional.ofNullable(clazz.cast(this.isActive()));
            }
            case "knowledgeBaseArn": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseArn()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "lastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "messageTemplateArn": {
                return Optional.ofNullable(clazz.cast(this.messageTemplateArn()));
            }
            case "messageTemplateContentSha256": {
                return Optional.ofNullable(clazz.cast(this.messageTemplateContentSha256()));
            }
            case "messageTemplateId": {
                return Optional.ofNullable(clazz.cast(this.messageTemplateId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "versionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attachments", ATTACHMENTS_FIELD);
        map.put("attributeTypes", ATTRIBUTE_TYPES_FIELD);
        map.put("channelSubtype", CHANNEL_SUBTYPE_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("defaultAttributes", DEFAULT_ATTRIBUTES_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("groupingConfiguration", GROUPING_CONFIGURATION_FIELD);
        map.put("isActive", IS_ACTIVE_FIELD);
        map.put("knowledgeBaseArn", KNOWLEDGE_BASE_ARN_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("lastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("messageTemplateArn", MESSAGE_TEMPLATE_ARN_FIELD);
        map.put("messageTemplateContentSha256", MESSAGE_TEMPLATE_CONTENT_SHA256_FIELD);
        map.put("messageTemplateId", MESSAGE_TEMPLATE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("versionNumber", VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExtendedMessageTemplateData, T> g) {
        return obj -> g.apply((ExtendedMessageTemplateData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MessageTemplateAttachment> attachments = DefaultSdkAutoConstructList.getInstance();
        private List<String> attributeTypes = DefaultSdkAutoConstructList.getInstance();
        private String channelSubtype;
        private MessageTemplateContentProvider content;
        private Instant createdTime;
        private MessageTemplateAttributes defaultAttributes;
        private String description;
        private GroupingConfiguration groupingConfiguration;
        private Boolean isActive;
        private String knowledgeBaseArn;
        private String knowledgeBaseId;
        private String language;
        private String lastModifiedBy;
        private Instant lastModifiedTime;
        private String messageTemplateArn;
        private String messageTemplateContentSha256;
        private String messageTemplateId;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Long versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtendedMessageTemplateData model) {
            this.attachments(model.attachments);
            this.attributeTypesWithStrings(model.attributeTypes);
            this.channelSubtype(model.channelSubtype);
            this.content(model.content);
            this.createdTime(model.createdTime);
            this.defaultAttributes(model.defaultAttributes);
            this.description(model.description);
            this.groupingConfiguration(model.groupingConfiguration);
            this.isActive(model.isActive);
            this.knowledgeBaseArn(model.knowledgeBaseArn);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.language(model.language);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.messageTemplateArn(model.messageTemplateArn);
            this.messageTemplateContentSha256(model.messageTemplateContentSha256);
            this.messageTemplateId(model.messageTemplateId);
            this.name(model.name);
            this.tags(model.tags);
            this.versionNumber(model.versionNumber);
        }

        public final List<MessageTemplateAttachment.Builder> getAttachments() {
            List<MessageTemplateAttachment.Builder> result = MessageTemplateAttachmentListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<MessageTemplateAttachment.BuilderImpl> attachments) {
            this.attachments = MessageTemplateAttachmentListCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<MessageTemplateAttachment> attachments) {
            this.attachments = MessageTemplateAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(MessageTemplateAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<MessageTemplateAttachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (MessageTemplateAttachment)((MessageTemplateAttachment.Builder)MessageTemplateAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAttributeTypes() {
            if (this.attributeTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeTypes;
        }

        public final void setAttributeTypes(Collection<String> attributeTypes) {
            this.attributeTypes = MessageTemplateAttributeTypeListCopier.copy(attributeTypes);
        }

        @Override
        public final Builder attributeTypesWithStrings(Collection<String> attributeTypes) {
            this.attributeTypes = MessageTemplateAttributeTypeListCopier.copy(attributeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeTypesWithStrings(String ... attributeTypes) {
            this.attributeTypesWithStrings(Arrays.asList(attributeTypes));
            return this;
        }

        @Override
        public final Builder attributeTypes(Collection<MessageTemplateAttributeType> attributeTypes) {
            this.attributeTypes = MessageTemplateAttributeTypeListCopier.copyEnumToString(attributeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeTypes(MessageTemplateAttributeType ... attributeTypes) {
            this.attributeTypes(Arrays.asList(attributeTypes));
            return this;
        }

        public final String getChannelSubtype() {
            return this.channelSubtype;
        }

        public final void setChannelSubtype(String channelSubtype) {
            this.channelSubtype = channelSubtype;
        }

        @Override
        public final Builder channelSubtype(String channelSubtype) {
            this.channelSubtype = channelSubtype;
            return this;
        }

        @Override
        public final Builder channelSubtype(ChannelSubtype channelSubtype) {
            this.channelSubtype(channelSubtype == null ? null : channelSubtype.toString());
            return this;
        }

        public final MessageTemplateContentProvider.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(MessageTemplateContentProvider.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(MessageTemplateContentProvider content) {
            this.content = content;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final MessageTemplateAttributes.Builder getDefaultAttributes() {
            return this.defaultAttributes != null ? this.defaultAttributes.toBuilder() : null;
        }

        public final void setDefaultAttributes(MessageTemplateAttributes.BuilderImpl defaultAttributes) {
            this.defaultAttributes = defaultAttributes != null ? defaultAttributes.build() : null;
        }

        @Override
        public final Builder defaultAttributes(MessageTemplateAttributes defaultAttributes) {
            this.defaultAttributes = defaultAttributes;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final GroupingConfiguration.Builder getGroupingConfiguration() {
            return this.groupingConfiguration != null ? this.groupingConfiguration.toBuilder() : null;
        }

        public final void setGroupingConfiguration(GroupingConfiguration.BuilderImpl groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration != null ? groupingConfiguration.build() : null;
        }

        @Override
        public final Builder groupingConfiguration(GroupingConfiguration groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        public final Boolean getIsActive() {
            return this.isActive;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return this.knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getMessageTemplateArn() {
            return this.messageTemplateArn;
        }

        public final void setMessageTemplateArn(String messageTemplateArn) {
            this.messageTemplateArn = messageTemplateArn;
        }

        @Override
        public final Builder messageTemplateArn(String messageTemplateArn) {
            this.messageTemplateArn = messageTemplateArn;
            return this;
        }

        public final String getMessageTemplateContentSha256() {
            return this.messageTemplateContentSha256;
        }

        public final void setMessageTemplateContentSha256(String messageTemplateContentSha256) {
            this.messageTemplateContentSha256 = messageTemplateContentSha256;
        }

        @Override
        public final Builder messageTemplateContentSha256(String messageTemplateContentSha256) {
            this.messageTemplateContentSha256 = messageTemplateContentSha256;
            return this;
        }

        public final String getMessageTemplateId() {
            return this.messageTemplateId;
        }

        public final void setMessageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
        }

        @Override
        public final Builder messageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public ExtendedMessageTemplateData build() {
            return new ExtendedMessageTemplateData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExtendedMessageTemplateData> {
        public Builder attachments(Collection<MessageTemplateAttachment> var1);

        public Builder attachments(MessageTemplateAttachment ... var1);

        public Builder attachments(Consumer<MessageTemplateAttachment.Builder> ... var1);

        public Builder attributeTypesWithStrings(Collection<String> var1);

        public Builder attributeTypesWithStrings(String ... var1);

        public Builder attributeTypes(Collection<MessageTemplateAttributeType> var1);

        public Builder attributeTypes(MessageTemplateAttributeType ... var1);

        public Builder channelSubtype(String var1);

        public Builder channelSubtype(ChannelSubtype var1);

        public Builder content(MessageTemplateContentProvider var1);

        default public Builder content(Consumer<MessageTemplateContentProvider.Builder> content) {
            return this.content((MessageTemplateContentProvider)((MessageTemplateContentProvider.Builder)MessageTemplateContentProvider.builder().applyMutation(content)).build());
        }

        public Builder createdTime(Instant var1);

        public Builder defaultAttributes(MessageTemplateAttributes var1);

        default public Builder defaultAttributes(Consumer<MessageTemplateAttributes.Builder> defaultAttributes) {
            return this.defaultAttributes((MessageTemplateAttributes)((MessageTemplateAttributes.Builder)MessageTemplateAttributes.builder().applyMutation(defaultAttributes)).build());
        }

        public Builder description(String var1);

        public Builder groupingConfiguration(GroupingConfiguration var1);

        default public Builder groupingConfiguration(Consumer<GroupingConfiguration.Builder> groupingConfiguration) {
            return this.groupingConfiguration((GroupingConfiguration)((GroupingConfiguration.Builder)GroupingConfiguration.builder().applyMutation(groupingConfiguration)).build());
        }

        public Builder isActive(Boolean var1);

        public Builder knowledgeBaseArn(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder language(String var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder messageTemplateArn(String var1);

        public Builder messageTemplateContentSha256(String var1);

        public Builder messageTemplateId(String var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder versionNumber(Long var1);
    }
}

