/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.ContentDisposition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageTemplateAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageTemplateAttachment> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachmentId").getter(MessageTemplateAttachment.getter(MessageTemplateAttachment::attachmentId)).setter(MessageTemplateAttachment.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentId").build()}).build();
    private static final SdkField<String> CONTENT_DISPOSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentDisposition").getter(MessageTemplateAttachment.getter(MessageTemplateAttachment::contentDispositionAsString)).setter(MessageTemplateAttachment.setter(Builder::contentDisposition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentDisposition").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(MessageTemplateAttachment.getter(MessageTemplateAttachment::name)).setter(MessageTemplateAttachment.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> UPLOADED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("uploadedTime").getter(MessageTemplateAttachment.getter(MessageTemplateAttachment::uploadedTime)).setter(MessageTemplateAttachment.setter(Builder::uploadedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(MessageTemplateAttachment.getter(MessageTemplateAttachment::url)).setter(MessageTemplateAttachment.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<Instant> URL_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("urlExpiry").getter(MessageTemplateAttachment.getter(MessageTemplateAttachment::urlExpiry)).setter(MessageTemplateAttachment.setter(Builder::urlExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("urlExpiry").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD, CONTENT_DISPOSITION_FIELD, NAME_FIELD, UPLOADED_TIME_FIELD, URL_FIELD, URL_EXPIRY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageTemplateAttachment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attachmentId;
    private final String contentDisposition;
    private final String name;
    private final Instant uploadedTime;
    private final String url;
    private final Instant urlExpiry;

    private MessageTemplateAttachment(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.contentDisposition = builder.contentDisposition;
        this.name = builder.name;
        this.uploadedTime = builder.uploadedTime;
        this.url = builder.url;
        this.urlExpiry = builder.urlExpiry;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final ContentDisposition contentDisposition() {
        return ContentDisposition.fromValue(this.contentDisposition);
    }

    public final String contentDispositionAsString() {
        return this.contentDisposition;
    }

    public final String name() {
        return this.name;
    }

    public final Instant uploadedTime() {
        return this.uploadedTime;
    }

    public final String url() {
        return this.url;
    }

    public final Instant urlExpiry() {
        return this.urlExpiry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlExpiry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateAttachment)) {
            return false;
        }
        MessageTemplateAttachment other = (MessageTemplateAttachment)obj;
        return Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.contentDispositionAsString(), other.contentDispositionAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.uploadedTime(), other.uploadedTime()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.urlExpiry(), other.urlExpiry());
    }

    public final String toString() {
        return ToString.builder((String)"MessageTemplateAttachment").add("AttachmentId", (Object)this.attachmentId()).add("ContentDisposition", (Object)this.contentDispositionAsString()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("UploadedTime", (Object)this.uploadedTime()).add("Url", (Object)(this.url() == null ? null : "*** Sensitive Data Redacted ***")).add("UrlExpiry", (Object)this.urlExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "contentDisposition": {
                return Optional.ofNullable(clazz.cast(this.contentDispositionAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "uploadedTime": {
                return Optional.ofNullable(clazz.cast(this.uploadedTime()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "urlExpiry": {
                return Optional.ofNullable(clazz.cast(this.urlExpiry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attachmentId", ATTACHMENT_ID_FIELD);
        map.put("contentDisposition", CONTENT_DISPOSITION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("uploadedTime", UPLOADED_TIME_FIELD);
        map.put("url", URL_FIELD);
        map.put("urlExpiry", URL_EXPIRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageTemplateAttachment, T> g) {
        return obj -> g.apply((MessageTemplateAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attachmentId;
        private String contentDisposition;
        private String name;
        private Instant uploadedTime;
        private String url;
        private Instant urlExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateAttachment model) {
            this.attachmentId(model.attachmentId);
            this.contentDisposition(model.contentDisposition);
            this.name(model.name);
            this.uploadedTime(model.uploadedTime);
            this.url(model.url);
            this.urlExpiry(model.urlExpiry);
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getContentDisposition() {
            return this.contentDisposition;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        @Override
        public final Builder contentDisposition(ContentDisposition contentDisposition) {
            this.contentDisposition(contentDisposition == null ? null : contentDisposition.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getUploadedTime() {
            return this.uploadedTime;
        }

        public final void setUploadedTime(Instant uploadedTime) {
            this.uploadedTime = uploadedTime;
        }

        @Override
        public final Builder uploadedTime(Instant uploadedTime) {
            this.uploadedTime = uploadedTime;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Instant getUrlExpiry() {
            return this.urlExpiry;
        }

        public final void setUrlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
        }

        @Override
        public final Builder urlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
            return this;
        }

        public MessageTemplateAttachment build() {
            return new MessageTemplateAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageTemplateAttachment> {
        public Builder attachmentId(String var1);

        public Builder contentDisposition(String var1);

        public Builder contentDisposition(ContentDisposition var1);

        public Builder name(String var1);

        public Builder uploadedTime(Instant var1);

        public Builder url(String var1);

        public Builder urlExpiry(Instant var1);
    }
}

