/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectAsyncClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.ListQuickResponsesRequest;
import software.amazon.awssdk.services.qconnect.model.ListQuickResponsesResponse;
import software.amazon.awssdk.services.qconnect.model.QuickResponseSummary;

public class ListQuickResponsesPublisher
implements SdkPublisher<ListQuickResponsesResponse> {
    private final QConnectAsyncClient client;
    private final ListQuickResponsesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQuickResponsesPublisher(QConnectAsyncClient client, ListQuickResponsesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQuickResponsesPublisher(QConnectAsyncClient client, ListQuickResponsesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQuickResponsesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQuickResponsesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<QuickResponseSummary> quickResponseSummaries() {
        Function<ListQuickResponsesResponse, Iterator> getIterator = response -> {
            if (response != null && response.quickResponseSummaries() != null) {
                return response.quickResponseSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListQuickResponsesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListQuickResponsesResponseFetcher
    implements AsyncPageFetcher<ListQuickResponsesResponse> {
        private ListQuickResponsesResponseFetcher() {
        }

        public boolean hasNextPage(ListQuickResponsesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQuickResponsesResponse> nextPage(ListQuickResponsesResponse previousPage) {
            if (previousPage == null) {
                return ListQuickResponsesPublisher.this.client.listQuickResponses(ListQuickResponsesPublisher.this.firstRequest);
            }
            return ListQuickResponsesPublisher.this.client.listQuickResponses((ListQuickResponsesRequest)((Object)ListQuickResponsesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

