/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AIAgentVersionSummary;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentVersionsResponse;

public class ListAIAgentVersionsIterable
implements SdkIterable<ListAiAgentVersionsResponse> {
    private final QConnectClient client;
    private final ListAiAgentVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAIAgentVersionsIterable(QConnectClient client, ListAiAgentVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAiAgentVersionsResponseFetcher();
    }

    public Iterator<ListAiAgentVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AIAgentVersionSummary> aiAgentVersionSummaries() {
        Function<ListAiAgentVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.aiAgentVersionSummaries() != null) {
                return response.aiAgentVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAiAgentVersionsResponseFetcher
    implements SyncPageFetcher<ListAiAgentVersionsResponse> {
        private ListAiAgentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAiAgentVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAiAgentVersionsResponse nextPage(ListAiAgentVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAIAgentVersionsIterable.this.client.listAIAgentVersions(ListAIAgentVersionsIterable.this.firstRequest);
            }
            return ListAIAgentVersionsIterable.this.client.listAIAgentVersions((ListAiAgentVersionsRequest)((Object)ListAIAgentVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

