/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.ConversationContext;
import software.amazon.awssdk.services.qconnect.model.MessageConfiguration;
import software.amazon.awssdk.services.qconnect.model.MessageInput;
import software.amazon.awssdk.services.qconnect.model.MessageType;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendMessageRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, SendMessageRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(SendMessageRequest.getter(SendMessageRequest::assistantId)).setter(SendMessageRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(SendMessageRequest.getter(SendMessageRequest::sessionId)).setter(SendMessageRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SendMessageRequest.getter(SendMessageRequest::typeAsString)).setter(SendMessageRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<MessageInput> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("message").getter(SendMessageRequest.getter(SendMessageRequest::message)).setter(SendMessageRequest.setter(Builder::message)).constructor(MessageInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<ConversationContext> CONVERSATION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conversationContext").getter(SendMessageRequest.getter(SendMessageRequest::conversationContext)).setter(SendMessageRequest.setter(Builder::conversationContext)).constructor(ConversationContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationContext").build()}).build();
    private static final SdkField<MessageConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(SendMessageRequest.getter(SendMessageRequest::configuration)).setter(SendMessageRequest.setter(Builder::configuration)).constructor(MessageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(SendMessageRequest.getter(SendMessageRequest::clientToken)).setter(SendMessageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD, SESSION_ID_FIELD, TYPE_FIELD, MESSAGE_FIELD, CONVERSATION_CONTEXT_FIELD, CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendMessageRequest.memberNameToFieldInitializer();
    private final String assistantId;
    private final String sessionId;
    private final String type;
    private final MessageInput message;
    private final ConversationContext conversationContext;
    private final MessageConfiguration configuration;
    private final String clientToken;

    private SendMessageRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.sessionId = builder.sessionId;
        this.type = builder.type;
        this.message = builder.message;
        this.conversationContext = builder.conversationContext;
        this.configuration = builder.configuration;
        this.clientToken = builder.clientToken;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final MessageType type() {
        return MessageType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final MessageInput message() {
        return this.message;
    }

    public final ConversationContext conversationContext() {
        return this.conversationContext;
    }

    public final MessageConfiguration configuration() {
        return this.configuration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageRequest)) {
            return false;
        }
        SendMessageRequest other = (SendMessageRequest)((Object)obj);
        return Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.conversationContext(), other.conversationContext()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"SendMessageRequest").add("AssistantId", (Object)this.assistantId()).add("SessionId", (Object)this.sessionId()).add("Type", (Object)this.typeAsString()).add("Message", (Object)this.message()).add("ConversationContext", (Object)this.conversationContext()).add("Configuration", (Object)this.configuration()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "conversationContext": {
                return Optional.ofNullable(clazz.cast(this.conversationContext()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("conversationContext", CONVERSATION_CONTEXT_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendMessageRequest, T> g) {
        return obj -> g.apply((SendMessageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String assistantId;
        private String sessionId;
        private String type;
        private MessageInput message;
        private ConversationContext conversationContext;
        private MessageConfiguration configuration;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageRequest model) {
            super(model);
            this.assistantId(model.assistantId);
            this.sessionId(model.sessionId);
            this.type(model.type);
            this.message(model.message);
            this.conversationContext(model.conversationContext);
            this.configuration(model.configuration);
            this.clientToken(model.clientToken);
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MessageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final MessageInput.Builder getMessage() {
            return this.message != null ? this.message.toBuilder() : null;
        }

        public final void setMessage(MessageInput.BuilderImpl message) {
            this.message = message != null ? message.build() : null;
        }

        @Override
        public final Builder message(MessageInput message) {
            this.message = message;
            return this;
        }

        public final ConversationContext.Builder getConversationContext() {
            return this.conversationContext != null ? this.conversationContext.toBuilder() : null;
        }

        public final void setConversationContext(ConversationContext.BuilderImpl conversationContext) {
            this.conversationContext = conversationContext != null ? conversationContext.build() : null;
        }

        @Override
        public final Builder conversationContext(ConversationContext conversationContext) {
            this.conversationContext = conversationContext;
            return this;
        }

        public final MessageConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(MessageConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(MessageConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendMessageRequest build() {
            return new SendMessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendMessageRequest> {
        public Builder assistantId(String var1);

        public Builder sessionId(String var1);

        public Builder type(String var1);

        public Builder type(MessageType var1);

        public Builder message(MessageInput var1);

        default public Builder message(Consumer<MessageInput.Builder> message) {
            return this.message((MessageInput)((MessageInput.Builder)MessageInput.builder().applyMutation(message)).build());
        }

        public Builder conversationContext(ConversationContext var1);

        default public Builder conversationContext(Consumer<ConversationContext.Builder> conversationContext) {
            return this.conversationContext((ConversationContext)((ConversationContext.Builder)ConversationContext.builder().applyMutation(conversationContext)).build());
        }

        public Builder configuration(MessageConfiguration var1);

        default public Builder configuration(Consumer<MessageConfiguration.Builder> configuration) {
            return this.configuration((MessageConfiguration)((MessageConfiguration.Builder)MessageConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

