/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionSummary> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(SessionSummary.getter(SessionSummary::sessionId)).setter(SessionSummary.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionArn").getter(SessionSummary.getter(SessionSummary::sessionArn)).setter(SessionSummary.setter(Builder::sessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(SessionSummary.getter(SessionSummary::assistantId)).setter(SessionSummary.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()}).build();
    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantArn").getter(SessionSummary.getter(SessionSummary::assistantArn)).setter(SessionSummary.setter(Builder::assistantArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, SESSION_ARN_FIELD, ASSISTANT_ID_FIELD, ASSISTANT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SessionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private final String sessionArn;
    private final String assistantId;
    private final String assistantArn;

    private SessionSummary(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
        this.sessionArn = builder.sessionArn;
        this.assistantId = builder.assistantId;
        this.assistantArn = builder.assistantArn;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String sessionArn() {
        return this.sessionArn;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String assistantArn() {
        return this.assistantArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionSummary)) {
            return false;
        }
        SessionSummary other = (SessionSummary)obj;
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.sessionArn(), other.sessionArn()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.assistantArn(), other.assistantArn());
    }

    public final String toString() {
        return ToString.builder((String)"SessionSummary").add("SessionId", (Object)this.sessionId()).add("SessionArn", (Object)this.sessionArn()).add("AssistantId", (Object)this.assistantId()).add("AssistantArn", (Object)this.assistantArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "sessionArn": {
                return Optional.ofNullable(clazz.cast(this.sessionArn()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "assistantArn": {
                return Optional.ofNullable(clazz.cast(this.assistantArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("assistantArn", ASSISTANT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionSummary, T> g) {
        return obj -> g.apply((SessionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sessionId;
        private String sessionArn;
        private String assistantId;
        private String assistantArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionSummary model) {
            this.sessionId(model.sessionId);
            this.sessionArn(model.sessionArn);
            this.assistantId(model.assistantId);
            this.assistantArn(model.assistantArn);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionArn() {
            return this.sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAssistantArn() {
            return this.assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public SessionSummary build() {
            return new SessionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionSummary> {
        public Builder sessionId(String var1);

        public Builder sessionArn(String var1);

        public Builder assistantId(String var1);

        public Builder assistantArn(String var1);
    }
}

