/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailSummary;
import software.amazon.awssdk.services.qconnect.model.ListAiGuardrailsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiGuardrailsResponse;

public class ListAIGuardrailsIterable
implements SdkIterable<ListAiGuardrailsResponse> {
    private final QConnectClient client;
    private final ListAiGuardrailsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAIGuardrailsIterable(QConnectClient client, ListAiGuardrailsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAiGuardrailsResponseFetcher();
    }

    public Iterator<ListAiGuardrailsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AIGuardrailSummary> aiGuardrailSummaries() {
        Function<ListAiGuardrailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.aiGuardrailSummaries() != null) {
                return response.aiGuardrailSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAiGuardrailsResponseFetcher
    implements SyncPageFetcher<ListAiGuardrailsResponse> {
        private ListAiGuardrailsResponseFetcher() {
        }

        public boolean hasNextPage(ListAiGuardrailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAiGuardrailsResponse nextPage(ListAiGuardrailsResponse previousPage) {
            if (previousPage == null) {
                return ListAIGuardrailsIterable.this.client.listAIGuardrails(ListAIGuardrailsIterable.this.firstRequest);
            }
            return ListAIGuardrailsIterable.this.client.listAIGuardrails((ListAiGuardrailsRequest)((Object)ListAIGuardrailsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

