/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.ListMessageTemplateVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListMessageTemplateVersionsResponse;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateVersionSummary;

public class ListMessageTemplateVersionsIterable
implements SdkIterable<ListMessageTemplateVersionsResponse> {
    private final QConnectClient client;
    private final ListMessageTemplateVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMessageTemplateVersionsIterable(QConnectClient client, ListMessageTemplateVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMessageTemplateVersionsResponseFetcher();
    }

    public Iterator<ListMessageTemplateVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MessageTemplateVersionSummary> messageTemplateVersionSummaries() {
        Function<ListMessageTemplateVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.messageTemplateVersionSummaries() != null) {
                return response.messageTemplateVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMessageTemplateVersionsResponseFetcher
    implements SyncPageFetcher<ListMessageTemplateVersionsResponse> {
        private ListMessageTemplateVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListMessageTemplateVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMessageTemplateVersionsResponse nextPage(ListMessageTemplateVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListMessageTemplateVersionsIterable.this.client.listMessageTemplateVersions(ListMessageTemplateVersionsIterable.this.firstRequest);
            }
            return ListMessageTemplateVersionsIterable.this.client.listMessageTemplateVersions((ListMessageTemplateVersionsRequest)((Object)ListMessageTemplateVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

