/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.RetrievalConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieveRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, RetrieveRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(RetrieveRequest.getter(RetrieveRequest::assistantId)).setter(RetrieveRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<RetrievalConfiguration> RETRIEVAL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retrievalConfiguration").getter(RetrieveRequest.getter(RetrieveRequest::retrievalConfiguration)).setter(RetrieveRequest.setter(Builder::retrievalConfiguration)).constructor(RetrievalConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalConfiguration").build()}).build();
    private static final SdkField<String> RETRIEVAL_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("retrievalQuery").getter(RetrieveRequest.getter(RetrieveRequest::retrievalQuery)).setter(RetrieveRequest.setter(Builder::retrievalQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalQuery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD, RETRIEVAL_CONFIGURATION_FIELD, RETRIEVAL_QUERY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetrieveRequest.memberNameToFieldInitializer();
    private final String assistantId;
    private final RetrievalConfiguration retrievalConfiguration;
    private final String retrievalQuery;

    private RetrieveRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.retrievalConfiguration = builder.retrievalConfiguration;
        this.retrievalQuery = builder.retrievalQuery;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final RetrievalConfiguration retrievalConfiguration() {
        return this.retrievalConfiguration;
    }

    public final String retrievalQuery() {
        return this.retrievalQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalQuery());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveRequest)) {
            return false;
        }
        RetrieveRequest other = (RetrieveRequest)((Object)obj);
        return Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.retrievalConfiguration(), other.retrievalConfiguration()) && Objects.equals(this.retrievalQuery(), other.retrievalQuery());
    }

    public final String toString() {
        return ToString.builder((String)"RetrieveRequest").add("AssistantId", (Object)this.assistantId()).add("RetrievalConfiguration", (Object)this.retrievalConfiguration()).add("RetrievalQuery", (Object)(this.retrievalQuery() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "retrievalConfiguration": {
                return Optional.ofNullable(clazz.cast(this.retrievalConfiguration()));
            }
            case "retrievalQuery": {
                return Optional.ofNullable(clazz.cast(this.retrievalQuery()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("retrievalConfiguration", RETRIEVAL_CONFIGURATION_FIELD);
        map.put("retrievalQuery", RETRIEVAL_QUERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrieveRequest, T> g) {
        return obj -> g.apply((RetrieveRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String assistantId;
        private RetrievalConfiguration retrievalConfiguration;
        private String retrievalQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveRequest model) {
            super(model);
            this.assistantId(model.assistantId);
            this.retrievalConfiguration(model.retrievalConfiguration);
            this.retrievalQuery(model.retrievalQuery);
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final RetrievalConfiguration.Builder getRetrievalConfiguration() {
            return this.retrievalConfiguration != null ? this.retrievalConfiguration.toBuilder() : null;
        }

        public final void setRetrievalConfiguration(RetrievalConfiguration.BuilderImpl retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration != null ? retrievalConfiguration.build() : null;
        }

        @Override
        public final Builder retrievalConfiguration(RetrievalConfiguration retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration;
            return this;
        }

        public final String getRetrievalQuery() {
            return this.retrievalQuery;
        }

        public final void setRetrievalQuery(String retrievalQuery) {
            this.retrievalQuery = retrievalQuery;
        }

        @Override
        public final Builder retrievalQuery(String retrievalQuery) {
            this.retrievalQuery = retrievalQuery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetrieveRequest build() {
            return new RetrieveRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RetrieveRequest> {
        public Builder assistantId(String var1);

        public Builder retrievalConfiguration(RetrievalConfiguration var1);

        default public Builder retrievalConfiguration(Consumer<RetrievalConfiguration.Builder> retrievalConfiguration) {
            return this.retrievalConfiguration((RetrievalConfiguration)((RetrievalConfiguration.Builder)RetrievalConfiguration.builder().applyMutation(retrievalConfiguration)).build());
        }

        public Builder retrievalQuery(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

