/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.QConnectResponse;
import software.amazon.awssdk.services.qconnect.model.RecommendationData;
import software.amazon.awssdk.services.qconnect.model.RecommendationListCopier;
import software.amazon.awssdk.services.qconnect.model.RecommendationTrigger;
import software.amazon.awssdk.services.qconnect.model.RecommendationTriggerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecommendationsResponse
extends QConnectResponse
implements ToCopyableBuilder<Builder, GetRecommendationsResponse> {
    private static final SdkField<List<RecommendationData>> RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendations").getter(GetRecommendationsResponse.getter(GetRecommendationsResponse::recommendations)).setter(GetRecommendationsResponse.setter(Builder::recommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RecommendationTrigger>> TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("triggers").getter(GetRecommendationsResponse.getter(GetRecommendationsResponse::triggers)).setter(GetRecommendationsResponse.setter(Builder::triggers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationTrigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATIONS_FIELD, TRIGGERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRecommendationsResponse.memberNameToFieldInitializer();
    private final List<RecommendationData> recommendations;
    private final List<RecommendationTrigger> triggers;

    private GetRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.recommendations = builder.recommendations;
        this.triggers = builder.triggers;
    }

    public final boolean hasRecommendations() {
        return this.recommendations != null && !(this.recommendations instanceof SdkAutoConstructList);
    }

    public final List<RecommendationData> recommendations() {
        return this.recommendations;
    }

    public final boolean hasTriggers() {
        return this.triggers != null && !(this.triggers instanceof SdkAutoConstructList);
    }

    public final List<RecommendationTrigger> triggers() {
        return this.triggers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendations() ? this.recommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggers() ? this.triggers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsResponse)) {
            return false;
        }
        GetRecommendationsResponse other = (GetRecommendationsResponse)((Object)obj);
        return this.hasRecommendations() == other.hasRecommendations() && Objects.equals(this.recommendations(), other.recommendations()) && this.hasTriggers() == other.hasTriggers() && Objects.equals(this.triggers(), other.triggers());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecommendationsResponse").add("Recommendations", this.hasRecommendations() ? this.recommendations() : null).add("Triggers", this.hasTriggers() ? this.triggers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recommendations": {
                return Optional.ofNullable(clazz.cast(this.recommendations()));
            }
            case "triggers": {
                return Optional.ofNullable(clazz.cast(this.triggers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recommendations", RECOMMENDATIONS_FIELD);
        map.put("triggers", TRIGGERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationsResponse, T> g) {
        return obj -> g.apply((GetRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectResponse.BuilderImpl
    implements Builder {
        private List<RecommendationData> recommendations = DefaultSdkAutoConstructList.getInstance();
        private List<RecommendationTrigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationsResponse model) {
            super(model);
            this.recommendations(model.recommendations);
            this.triggers(model.triggers);
        }

        public final List<RecommendationData.Builder> getRecommendations() {
            List<RecommendationData.Builder> result = RecommendationListCopier.copyToBuilder(this.recommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendations(Collection<RecommendationData.BuilderImpl> recommendations) {
            this.recommendations = RecommendationListCopier.copyFromBuilder(recommendations);
        }

        @Override
        public final Builder recommendations(Collection<RecommendationData> recommendations) {
            this.recommendations = RecommendationListCopier.copy(recommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(RecommendationData ... recommendations) {
            this.recommendations(Arrays.asList(recommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Consumer<RecommendationData.Builder> ... recommendations) {
            this.recommendations(Stream.of(recommendations).map(c -> (RecommendationData)((RecommendationData.Builder)RecommendationData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RecommendationTrigger.Builder> getTriggers() {
            List<RecommendationTrigger.Builder> result = RecommendationTriggerListCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<RecommendationTrigger.BuilderImpl> triggers) {
            this.triggers = RecommendationTriggerListCopier.copyFromBuilder(triggers);
        }

        @Override
        public final Builder triggers(Collection<RecommendationTrigger> triggers) {
            this.triggers = RecommendationTriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(RecommendationTrigger ... triggers) {
            this.triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<RecommendationTrigger.Builder> ... triggers) {
            this.triggers(Stream.of(triggers).map(c -> (RecommendationTrigger)((RecommendationTrigger.Builder)RecommendationTrigger.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRecommendationsResponse build() {
            return new GetRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecommendationsResponse> {
        public Builder recommendations(Collection<RecommendationData> var1);

        public Builder recommendations(RecommendationData ... var1);

        public Builder recommendations(Consumer<RecommendationData.Builder> ... var1);

        public Builder triggers(Collection<RecommendationTrigger> var1);

        public Builder triggers(RecommendationTrigger ... var1);

        public Builder triggers(Consumer<RecommendationTrigger.Builder> ... var1);
    }
}

