/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReferenceType {
    WEB_CRAWLER("WEB_CRAWLER"),
    KNOWLEDGE_BASE("KNOWLEDGE_BASE"),
    BEDROCK_KB_S3("BEDROCK_KB_S3"),
    BEDROCK_KB_WEB("BEDROCK_KB_WEB"),
    BEDROCK_KB_CONFLUENCE("BEDROCK_KB_CONFLUENCE"),
    BEDROCK_KB_SALESFORCE("BEDROCK_KB_SALESFORCE"),
    BEDROCK_KB_SHAREPOINT("BEDROCK_KB_SHAREPOINT"),
    BEDROCK_KB_KENDRA("BEDROCK_KB_KENDRA"),
    BEDROCK_KB_CUSTOM_DOCUMENT("BEDROCK_KB_CUSTOM_DOCUMENT"),
    BEDROCK_KB_SQL("BEDROCK_KB_SQL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReferenceType> VALUE_MAP;
    private final String value;

    private ReferenceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReferenceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReferenceType> knownValues() {
        EnumSet<ReferenceType> knownValues = EnumSet.allOf(ReferenceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReferenceType.class, ReferenceType::toString);
    }
}

