/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectAsyncClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.ListSpansRequest;
import software.amazon.awssdk.services.qconnect.model.ListSpansResponse;
import software.amazon.awssdk.services.qconnect.model.Span;

public class ListSpansPublisher
implements SdkPublisher<ListSpansResponse> {
    private final QConnectAsyncClient client;
    private final ListSpansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSpansPublisher(QConnectAsyncClient client, ListSpansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSpansPublisher(QConnectAsyncClient client, ListSpansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSpansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSpansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Span> spans() {
        Function<ListSpansResponse, Iterator> getIterator = response -> {
            if (response != null && response.spans() != null) {
                return response.spans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSpansResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSpansResponseFetcher
    implements AsyncPageFetcher<ListSpansResponse> {
        private ListSpansResponseFetcher() {
        }

        public boolean hasNextPage(ListSpansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSpansResponse> nextPage(ListSpansResponse previousPage) {
            if (previousPage == null) {
                return ListSpansPublisher.this.client.listSpans(ListSpansPublisher.this.firstRequest);
            }
            return ListSpansPublisher.this.client.listSpans((ListSpansRequest)((Object)ListSpansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

