/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.QueryAssistantRequest;
import software.amazon.awssdk.services.qconnect.model.QueryAssistantResponse;
import software.amazon.awssdk.services.qconnect.model.ResultData;

public class QueryAssistantIterable
implements SdkIterable<QueryAssistantResponse> {
    private final QConnectClient client;
    private final QueryAssistantRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public QueryAssistantIterable(QConnectClient client, QueryAssistantRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new QueryAssistantResponseFetcher();
    }

    public Iterator<QueryAssistantResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResultData> results() {
        Function<QueryAssistantResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class QueryAssistantResponseFetcher
    implements SyncPageFetcher<QueryAssistantResponse> {
        private QueryAssistantResponseFetcher() {
        }

        public boolean hasNextPage(QueryAssistantResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public QueryAssistantResponse nextPage(QueryAssistantResponse previousPage) {
            if (previousPage == null) {
                return QueryAssistantIterable.this.client.queryAssistant(QueryAssistantIterable.this.firstRequest);
            }
            return QueryAssistantIterable.this.client.queryAssistant((QueryAssistantRequest)((Object)QueryAssistantIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

