/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisConfiguration> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamArn").getter(KinesisConfiguration.getter(KinesisConfiguration::streamArn)).setter(KinesisConfiguration.setter(Builder::streamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()}).build();
    private static final SdkField<Boolean> AGGREGATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AggregationEnabled").getter(KinesisConfiguration.getter(KinesisConfiguration::aggregationEnabled)).setter(KinesisConfiguration.setter(Builder::aggregationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, AGGREGATION_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KinesisConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String streamArn;
    private final Boolean aggregationEnabled;

    private KinesisConfiguration(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.aggregationEnabled = builder.aggregationEnabled;
    }

    public final String streamArn() {
        return this.streamArn;
    }

    public final Boolean aggregationEnabled() {
        return this.aggregationEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisConfiguration)) {
            return false;
        }
        KinesisConfiguration other = (KinesisConfiguration)obj;
        return Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.aggregationEnabled(), other.aggregationEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisConfiguration").add("StreamArn", (Object)this.streamArn()).add("AggregationEnabled", (Object)this.aggregationEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "AggregationEnabled": {
                return Optional.ofNullable(clazz.cast(this.aggregationEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamArn", STREAM_ARN_FIELD);
        map.put("AggregationEnabled", AGGREGATION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisConfiguration, T> g) {
        return obj -> g.apply((KinesisConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamArn;
        private Boolean aggregationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisConfiguration model) {
            this.streamArn(model.streamArn);
            this.aggregationEnabled(model.aggregationEnabled);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final Boolean getAggregationEnabled() {
            return this.aggregationEnabled;
        }

        public final void setAggregationEnabled(Boolean aggregationEnabled) {
            this.aggregationEnabled = aggregationEnabled;
        }

        @Override
        public final Builder aggregationEnabled(Boolean aggregationEnabled) {
            this.aggregationEnabled = aggregationEnabled;
            return this;
        }

        public KinesisConfiguration build() {
            return new KinesisConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisConfiguration> {
        public Builder streamArn(String var1);

        public Builder aggregationEnabled(Boolean var1);
    }
}

