/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.EncryptionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LedgerEncryptionDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LedgerEncryptionDescription> {
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(LedgerEncryptionDescription.getter(LedgerEncryptionDescription::kmsKeyArn)).setter(LedgerEncryptionDescription.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<String> ENCRYPTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionStatus").getter(LedgerEncryptionDescription.getter(LedgerEncryptionDescription::encryptionStatusAsString)).setter(LedgerEncryptionDescription.setter(Builder::encryptionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionStatus").build()}).build();
    private static final SdkField<Instant> INACCESSIBLE_KMS_KEY_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InaccessibleKmsKeyDateTime").getter(LedgerEncryptionDescription.getter(LedgerEncryptionDescription::inaccessibleKmsKeyDateTime)).setter(LedgerEncryptionDescription.setter(Builder::inaccessibleKmsKeyDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InaccessibleKmsKeyDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ARN_FIELD, ENCRYPTION_STATUS_FIELD, INACCESSIBLE_KMS_KEY_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LedgerEncryptionDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String kmsKeyArn;
    private final String encryptionStatus;
    private final Instant inaccessibleKmsKeyDateTime;

    private LedgerEncryptionDescription(BuilderImpl builder) {
        this.kmsKeyArn = builder.kmsKeyArn;
        this.encryptionStatus = builder.encryptionStatus;
        this.inaccessibleKmsKeyDateTime = builder.inaccessibleKmsKeyDateTime;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final EncryptionStatus encryptionStatus() {
        return EncryptionStatus.fromValue(this.encryptionStatus);
    }

    public final String encryptionStatusAsString() {
        return this.encryptionStatus;
    }

    public final Instant inaccessibleKmsKeyDateTime() {
        return this.inaccessibleKmsKeyDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inaccessibleKmsKeyDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LedgerEncryptionDescription)) {
            return false;
        }
        LedgerEncryptionDescription other = (LedgerEncryptionDescription)obj;
        return Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.encryptionStatusAsString(), other.encryptionStatusAsString()) && Objects.equals(this.inaccessibleKmsKeyDateTime(), other.inaccessibleKmsKeyDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"LedgerEncryptionDescription").add("KmsKeyArn", (Object)this.kmsKeyArn()).add("EncryptionStatus", (Object)this.encryptionStatusAsString()).add("InaccessibleKmsKeyDateTime", (Object)this.inaccessibleKmsKeyDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "EncryptionStatus": {
                return Optional.ofNullable(clazz.cast(this.encryptionStatusAsString()));
            }
            case "InaccessibleKmsKeyDateTime": {
                return Optional.ofNullable(clazz.cast(this.inaccessibleKmsKeyDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("EncryptionStatus", ENCRYPTION_STATUS_FIELD);
        map.put("InaccessibleKmsKeyDateTime", INACCESSIBLE_KMS_KEY_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LedgerEncryptionDescription, T> g) {
        return obj -> g.apply((LedgerEncryptionDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyArn;
        private String encryptionStatus;
        private Instant inaccessibleKmsKeyDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LedgerEncryptionDescription model) {
            this.kmsKeyArn(model.kmsKeyArn);
            this.encryptionStatus(model.encryptionStatus);
            this.inaccessibleKmsKeyDateTime(model.inaccessibleKmsKeyDateTime);
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getEncryptionStatus() {
            return this.encryptionStatus;
        }

        public final void setEncryptionStatus(String encryptionStatus) {
            this.encryptionStatus = encryptionStatus;
        }

        @Override
        public final Builder encryptionStatus(String encryptionStatus) {
            this.encryptionStatus = encryptionStatus;
            return this;
        }

        @Override
        public final Builder encryptionStatus(EncryptionStatus encryptionStatus) {
            this.encryptionStatus(encryptionStatus == null ? null : encryptionStatus.toString());
            return this;
        }

        public final Instant getInaccessibleKmsKeyDateTime() {
            return this.inaccessibleKmsKeyDateTime;
        }

        public final void setInaccessibleKmsKeyDateTime(Instant inaccessibleKmsKeyDateTime) {
            this.inaccessibleKmsKeyDateTime = inaccessibleKmsKeyDateTime;
        }

        @Override
        public final Builder inaccessibleKmsKeyDateTime(Instant inaccessibleKmsKeyDateTime) {
            this.inaccessibleKmsKeyDateTime = inaccessibleKmsKeyDateTime;
            return this;
        }

        public LedgerEncryptionDescription build() {
            return new LedgerEncryptionDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LedgerEncryptionDescription> {
        public Builder kmsKeyArn(String var1);

        public Builder encryptionStatus(String var1);

        public Builder encryptionStatus(EncryptionStatus var1);

        public Builder inaccessibleKmsKeyDateTime(Instant var1);
    }
}

