/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qldb.QldbClient;
import software.amazon.awssdk.services.qldb.internal.UserAgentUtils;
import software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest;
import software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse;

public class ListJournalKinesisStreamsForLedgerIterable
implements SdkIterable<ListJournalKinesisStreamsForLedgerResponse> {
    private final QldbClient client;
    private final ListJournalKinesisStreamsForLedgerRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJournalKinesisStreamsForLedgerIterable(QldbClient client, ListJournalKinesisStreamsForLedgerRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListJournalKinesisStreamsForLedgerResponseFetcher();
    }

    public Iterator<ListJournalKinesisStreamsForLedgerResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListJournalKinesisStreamsForLedgerResponseFetcher
    implements SyncPageFetcher<ListJournalKinesisStreamsForLedgerResponse> {
        private ListJournalKinesisStreamsForLedgerResponseFetcher() {
        }

        public boolean hasNextPage(ListJournalKinesisStreamsForLedgerResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListJournalKinesisStreamsForLedgerResponse nextPage(ListJournalKinesisStreamsForLedgerResponse previousPage) {
            if (previousPage == null) {
                return ListJournalKinesisStreamsForLedgerIterable.this.client.listJournalKinesisStreamsForLedger(ListJournalKinesisStreamsForLedgerIterable.this.firstRequest);
            }
            return ListJournalKinesisStreamsForLedgerIterable.this.client.listJournalKinesisStreamsForLedger((ListJournalKinesisStreamsForLedgerRequest)((Object)ListJournalKinesisStreamsForLedgerIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

