/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataLabelPosition;
import software.amazon.awssdk.services.quicksight.model.FontConfiguration;
import software.amazon.awssdk.services.quicksight.model.FunnelChartMeasureDataLabelStyle;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunnelChartDataLabelOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunnelChartDataLabelOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(FunnelChartDataLabelOptions.getter(FunnelChartDataLabelOptions::visibilityAsString)).setter(FunnelChartDataLabelOptions.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<String> CATEGORY_LABEL_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CategoryLabelVisibility").getter(FunnelChartDataLabelOptions.getter(FunnelChartDataLabelOptions::categoryLabelVisibilityAsString)).setter(FunnelChartDataLabelOptions.setter(Builder::categoryLabelVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelVisibility").build()}).build();
    private static final SdkField<String> MEASURE_LABEL_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureLabelVisibility").getter(FunnelChartDataLabelOptions.getter(FunnelChartDataLabelOptions::measureLabelVisibilityAsString)).setter(FunnelChartDataLabelOptions.setter(Builder::measureLabelVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureLabelVisibility").build()}).build();
    private static final SdkField<String> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Position").getter(FunnelChartDataLabelOptions.getter(FunnelChartDataLabelOptions::positionAsString)).setter(FunnelChartDataLabelOptions.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build()}).build();
    private static final SdkField<FontConfiguration> LABEL_FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelFontConfiguration").getter(FunnelChartDataLabelOptions.getter(FunnelChartDataLabelOptions::labelFontConfiguration)).setter(FunnelChartDataLabelOptions.setter(Builder::labelFontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelFontConfiguration").build()}).build();
    private static final SdkField<String> LABEL_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelColor").getter(FunnelChartDataLabelOptions.getter(FunnelChartDataLabelOptions::labelColor)).setter(FunnelChartDataLabelOptions.setter(Builder::labelColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelColor").build()}).build();
    private static final SdkField<String> MEASURE_DATA_LABEL_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureDataLabelStyle").getter(FunnelChartDataLabelOptions.getter(FunnelChartDataLabelOptions::measureDataLabelStyleAsString)).setter(FunnelChartDataLabelOptions.setter(Builder::measureDataLabelStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureDataLabelStyle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD, CATEGORY_LABEL_VISIBILITY_FIELD, MEASURE_LABEL_VISIBILITY_FIELD, POSITION_FIELD, LABEL_FONT_CONFIGURATION_FIELD, LABEL_COLOR_FIELD, MEASURE_DATA_LABEL_STYLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FunnelChartDataLabelOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String visibility;
    private final String categoryLabelVisibility;
    private final String measureLabelVisibility;
    private final String position;
    private final FontConfiguration labelFontConfiguration;
    private final String labelColor;
    private final String measureDataLabelStyle;

    private FunnelChartDataLabelOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.categoryLabelVisibility = builder.categoryLabelVisibility;
        this.measureLabelVisibility = builder.measureLabelVisibility;
        this.position = builder.position;
        this.labelFontConfiguration = builder.labelFontConfiguration;
        this.labelColor = builder.labelColor;
        this.measureDataLabelStyle = builder.measureDataLabelStyle;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final Visibility categoryLabelVisibility() {
        return Visibility.fromValue(this.categoryLabelVisibility);
    }

    public final String categoryLabelVisibilityAsString() {
        return this.categoryLabelVisibility;
    }

    public final Visibility measureLabelVisibility() {
        return Visibility.fromValue(this.measureLabelVisibility);
    }

    public final String measureLabelVisibilityAsString() {
        return this.measureLabelVisibility;
    }

    public final DataLabelPosition position() {
        return DataLabelPosition.fromValue(this.position);
    }

    public final String positionAsString() {
        return this.position;
    }

    public final FontConfiguration labelFontConfiguration() {
        return this.labelFontConfiguration;
    }

    public final String labelColor() {
        return this.labelColor;
    }

    public final FunnelChartMeasureDataLabelStyle measureDataLabelStyle() {
        return FunnelChartMeasureDataLabelStyle.fromValue(this.measureDataLabelStyle);
    }

    public final String measureDataLabelStyleAsString() {
        return this.measureDataLabelStyle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryLabelVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.measureLabelVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.positionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelFontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.measureDataLabelStyleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunnelChartDataLabelOptions)) {
            return false;
        }
        FunnelChartDataLabelOptions other = (FunnelChartDataLabelOptions)obj;
        return Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.categoryLabelVisibilityAsString(), other.categoryLabelVisibilityAsString()) && Objects.equals(this.measureLabelVisibilityAsString(), other.measureLabelVisibilityAsString()) && Objects.equals(this.positionAsString(), other.positionAsString()) && Objects.equals(this.labelFontConfiguration(), other.labelFontConfiguration()) && Objects.equals(this.labelColor(), other.labelColor()) && Objects.equals(this.measureDataLabelStyleAsString(), other.measureDataLabelStyleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FunnelChartDataLabelOptions").add("Visibility", (Object)this.visibilityAsString()).add("CategoryLabelVisibility", (Object)this.categoryLabelVisibilityAsString()).add("MeasureLabelVisibility", (Object)this.measureLabelVisibilityAsString()).add("Position", (Object)this.positionAsString()).add("LabelFontConfiguration", (Object)this.labelFontConfiguration()).add("LabelColor", (Object)this.labelColor()).add("MeasureDataLabelStyle", (Object)this.measureDataLabelStyleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "CategoryLabelVisibility": {
                return Optional.ofNullable(clazz.cast(this.categoryLabelVisibilityAsString()));
            }
            case "MeasureLabelVisibility": {
                return Optional.ofNullable(clazz.cast(this.measureLabelVisibilityAsString()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.positionAsString()));
            }
            case "LabelFontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.labelFontConfiguration()));
            }
            case "LabelColor": {
                return Optional.ofNullable(clazz.cast(this.labelColor()));
            }
            case "MeasureDataLabelStyle": {
                return Optional.ofNullable(clazz.cast(this.measureDataLabelStyleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("CategoryLabelVisibility", CATEGORY_LABEL_VISIBILITY_FIELD);
        map.put("MeasureLabelVisibility", MEASURE_LABEL_VISIBILITY_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("LabelFontConfiguration", LABEL_FONT_CONFIGURATION_FIELD);
        map.put("LabelColor", LABEL_COLOR_FIELD);
        map.put("MeasureDataLabelStyle", MEASURE_DATA_LABEL_STYLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FunnelChartDataLabelOptions, T> g) {
        return obj -> g.apply((FunnelChartDataLabelOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visibility;
        private String categoryLabelVisibility;
        private String measureLabelVisibility;
        private String position;
        private FontConfiguration labelFontConfiguration;
        private String labelColor;
        private String measureDataLabelStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(FunnelChartDataLabelOptions model) {
            this.visibility(model.visibility);
            this.categoryLabelVisibility(model.categoryLabelVisibility);
            this.measureLabelVisibility(model.measureLabelVisibility);
            this.position(model.position);
            this.labelFontConfiguration(model.labelFontConfiguration);
            this.labelColor(model.labelColor);
            this.measureDataLabelStyle(model.measureDataLabelStyle);
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getCategoryLabelVisibility() {
            return this.categoryLabelVisibility;
        }

        public final void setCategoryLabelVisibility(String categoryLabelVisibility) {
            this.categoryLabelVisibility = categoryLabelVisibility;
        }

        @Override
        public final Builder categoryLabelVisibility(String categoryLabelVisibility) {
            this.categoryLabelVisibility = categoryLabelVisibility;
            return this;
        }

        @Override
        public final Builder categoryLabelVisibility(Visibility categoryLabelVisibility) {
            this.categoryLabelVisibility(categoryLabelVisibility == null ? null : categoryLabelVisibility.toString());
            return this;
        }

        public final String getMeasureLabelVisibility() {
            return this.measureLabelVisibility;
        }

        public final void setMeasureLabelVisibility(String measureLabelVisibility) {
            this.measureLabelVisibility = measureLabelVisibility;
        }

        @Override
        public final Builder measureLabelVisibility(String measureLabelVisibility) {
            this.measureLabelVisibility = measureLabelVisibility;
            return this;
        }

        @Override
        public final Builder measureLabelVisibility(Visibility measureLabelVisibility) {
            this.measureLabelVisibility(measureLabelVisibility == null ? null : measureLabelVisibility.toString());
            return this;
        }

        public final String getPosition() {
            return this.position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        @Override
        public final Builder position(DataLabelPosition position) {
            this.position(position == null ? null : position.toString());
            return this;
        }

        public final FontConfiguration.Builder getLabelFontConfiguration() {
            return this.labelFontConfiguration != null ? this.labelFontConfiguration.toBuilder() : null;
        }

        public final void setLabelFontConfiguration(FontConfiguration.BuilderImpl labelFontConfiguration) {
            this.labelFontConfiguration = labelFontConfiguration != null ? labelFontConfiguration.build() : null;
        }

        @Override
        public final Builder labelFontConfiguration(FontConfiguration labelFontConfiguration) {
            this.labelFontConfiguration = labelFontConfiguration;
            return this;
        }

        public final String getLabelColor() {
            return this.labelColor;
        }

        public final void setLabelColor(String labelColor) {
            this.labelColor = labelColor;
        }

        @Override
        public final Builder labelColor(String labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public final String getMeasureDataLabelStyle() {
            return this.measureDataLabelStyle;
        }

        public final void setMeasureDataLabelStyle(String measureDataLabelStyle) {
            this.measureDataLabelStyle = measureDataLabelStyle;
        }

        @Override
        public final Builder measureDataLabelStyle(String measureDataLabelStyle) {
            this.measureDataLabelStyle = measureDataLabelStyle;
            return this;
        }

        @Override
        public final Builder measureDataLabelStyle(FunnelChartMeasureDataLabelStyle measureDataLabelStyle) {
            this.measureDataLabelStyle(measureDataLabelStyle == null ? null : measureDataLabelStyle.toString());
            return this;
        }

        public FunnelChartDataLabelOptions build() {
            return new FunnelChartDataLabelOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunnelChartDataLabelOptions> {
        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder categoryLabelVisibility(String var1);

        public Builder categoryLabelVisibility(Visibility var1);

        public Builder measureLabelVisibility(String var1);

        public Builder measureLabelVisibility(Visibility var1);

        public Builder position(String var1);

        public Builder position(DataLabelPosition var1);

        public Builder labelFontConfiguration(FontConfiguration var1);

        default public Builder labelFontConfiguration(Consumer<FontConfiguration.Builder> labelFontConfiguration) {
            return this.labelFontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(labelFontConfiguration)).build());
        }

        public Builder labelColor(String var1);

        public Builder measureDataLabelStyle(String var1);

        public Builder measureDataLabelStyle(FunnelChartMeasureDataLabelStyle var1);
    }
}

