/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.TopicDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTopicRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateTopicRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateTopicRequest.getter(UpdateTopicRequest::awsAccountId)).setter(UpdateTopicRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicId").getter(UpdateTopicRequest.getter(UpdateTopicRequest::topicId)).setter(UpdateTopicRequest.setter(Builder::topicId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TopicId").build()}).build();
    private static final SdkField<TopicDetails> TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Topic").getter(UpdateTopicRequest.getter(UpdateTopicRequest::topic)).setter(UpdateTopicRequest.setter(Builder::topic)).constructor(TopicDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, TOPIC_ID_FIELD, TOPIC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTopicRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String topicId;
    private final TopicDetails topic;

    private UpdateTopicRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.topicId = builder.topicId;
        this.topic = builder.topic;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String topicId() {
        return this.topicId;
    }

    public final TopicDetails topic() {
        return this.topic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicId());
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTopicRequest)) {
            return false;
        }
        UpdateTopicRequest other = (UpdateTopicRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.topicId(), other.topicId()) && Objects.equals(this.topic(), other.topic());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTopicRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("TopicId", (Object)this.topicId()).add("Topic", (Object)this.topic()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "TopicId": {
                return Optional.ofNullable(clazz.cast(this.topicId()));
            }
            case "Topic": {
                return Optional.ofNullable(clazz.cast(this.topic()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("TopicId", TOPIC_ID_FIELD);
        map.put("Topic", TOPIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTopicRequest, T> g) {
        return obj -> g.apply((UpdateTopicRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String topicId;
        private TopicDetails topic;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTopicRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.topicId(model.topicId);
            this.topic(model.topic);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getTopicId() {
            return this.topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final TopicDetails.Builder getTopic() {
            return this.topic != null ? this.topic.toBuilder() : null;
        }

        public final void setTopic(TopicDetails.BuilderImpl topic) {
            this.topic = topic != null ? topic.build() : null;
        }

        @Override
        public final Builder topic(TopicDetails topic) {
            this.topic = topic;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTopicRequest build() {
            return new UpdateTopicRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTopicRequest> {
        public Builder awsAccountId(String var1);

        public Builder topicId(String var1);

        public Builder topic(TopicDetails var1);

        default public Builder topic(Consumer<TopicDetails.Builder> topic) {
            return this.topic((TopicDetails)((TopicDetails.Builder)TopicDetails.builder().applyMutation(topic)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

