/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DashboardError;
import software.amazon.awssdk.services.quicksight.model.DashboardErrorListCopier;
import software.amazon.awssdk.services.quicksight.model.DataSetArnsListCopier;
import software.amazon.awssdk.services.quicksight.model.ResourceStatus;
import software.amazon.awssdk.services.quicksight.model.Sheet;
import software.amazon.awssdk.services.quicksight.model.SheetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashboardVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashboardVersion> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DashboardVersion.getter(DashboardVersion::createdTime)).setter(DashboardVersion.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<List<DashboardError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(DashboardVersion.getter(DashboardVersion::errors)).setter(DashboardVersion.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DashboardError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionNumber").getter(DashboardVersion.getter(DashboardVersion::versionNumber)).setter(DashboardVersion.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DashboardVersion.getter(DashboardVersion::statusAsString)).setter(DashboardVersion.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DashboardVersion.getter(DashboardVersion::arn)).setter(DashboardVersion.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> SOURCE_ENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEntityArn").getter(DashboardVersion.getter(DashboardVersion::sourceEntityArn)).setter(DashboardVersion.setter(Builder::sourceEntityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntityArn").build()}).build();
    private static final SdkField<List<String>> DATA_SET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataSetArns").getter(DashboardVersion.getter(DashboardVersion::dataSetArns)).setter(DashboardVersion.setter(Builder::dataSetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DashboardVersion.getter(DashboardVersion::description)).setter(DashboardVersion.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> THEME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeArn").getter(DashboardVersion.getter(DashboardVersion::themeArn)).setter(DashboardVersion.setter(Builder::themeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()}).build();
    private static final SdkField<List<Sheet>> SHEETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sheets").getter(DashboardVersion.getter(DashboardVersion::sheets)).setter(DashboardVersion.setter(Builder::sheets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sheets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Sheet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD, ERRORS_FIELD, VERSION_NUMBER_FIELD, STATUS_FIELD, ARN_FIELD, SOURCE_ENTITY_ARN_FIELD, DATA_SET_ARNS_FIELD, DESCRIPTION_FIELD, THEME_ARN_FIELD, SHEETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DashboardVersion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdTime;
    private final List<DashboardError> errors;
    private final Long versionNumber;
    private final String status;
    private final String arn;
    private final String sourceEntityArn;
    private final List<String> dataSetArns;
    private final String description;
    private final String themeArn;
    private final List<Sheet> sheets;

    private DashboardVersion(BuilderImpl builder) {
        this.createdTime = builder.createdTime;
        this.errors = builder.errors;
        this.versionNumber = builder.versionNumber;
        this.status = builder.status;
        this.arn = builder.arn;
        this.sourceEntityArn = builder.sourceEntityArn;
        this.dataSetArns = builder.dataSetArns;
        this.description = builder.description;
        this.themeArn = builder.themeArn;
        this.sheets = builder.sheets;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<DashboardError> errors() {
        return this.errors;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    public final ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String sourceEntityArn() {
        return this.sourceEntityArn;
    }

    public final boolean hasDataSetArns() {
        return this.dataSetArns != null && !(this.dataSetArns instanceof SdkAutoConstructList);
    }

    public final List<String> dataSetArns() {
        return this.dataSetArns;
    }

    public final String description() {
        return this.description;
    }

    public final String themeArn() {
        return this.themeArn;
    }

    public final boolean hasSheets() {
        return this.sheets != null && !(this.sheets instanceof SdkAutoConstructList);
    }

    public final List<Sheet> sheets() {
        return this.sheets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEntityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSetArns() ? this.dataSetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSheets() ? this.sheets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardVersion)) {
            return false;
        }
        DashboardVersion other = (DashboardVersion)obj;
        return Objects.equals(this.createdTime(), other.createdTime()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.sourceEntityArn(), other.sourceEntityArn()) && this.hasDataSetArns() == other.hasDataSetArns() && Objects.equals(this.dataSetArns(), other.dataSetArns()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.themeArn(), other.themeArn()) && this.hasSheets() == other.hasSheets() && Objects.equals(this.sheets(), other.sheets());
    }

    public final String toString() {
        return ToString.builder((String)"DashboardVersion").add("CreatedTime", (Object)this.createdTime()).add("Errors", this.hasErrors() ? this.errors() : null).add("VersionNumber", (Object)this.versionNumber()).add("Status", (Object)this.statusAsString()).add("Arn", (Object)this.arn()).add("SourceEntityArn", (Object)this.sourceEntityArn()).add("DataSetArns", this.hasDataSetArns() ? this.dataSetArns() : null).add("Description", (Object)this.description()).add("ThemeArn", (Object)this.themeArn()).add("Sheets", this.hasSheets() ? this.sheets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "SourceEntityArn": {
                return Optional.ofNullable(clazz.cast(this.sourceEntityArn()));
            }
            case "DataSetArns": {
                return Optional.ofNullable(clazz.cast(this.dataSetArns()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ThemeArn": {
                return Optional.ofNullable(clazz.cast(this.themeArn()));
            }
            case "Sheets": {
                return Optional.ofNullable(clazz.cast(this.sheets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("Errors", ERRORS_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("SourceEntityArn", SOURCE_ENTITY_ARN_FIELD);
        map.put("DataSetArns", DATA_SET_ARNS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ThemeArn", THEME_ARN_FIELD);
        map.put("Sheets", SHEETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashboardVersion, T> g) {
        return obj -> g.apply((DashboardVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdTime;
        private List<DashboardError> errors = DefaultSdkAutoConstructList.getInstance();
        private Long versionNumber;
        private String status;
        private String arn;
        private String sourceEntityArn;
        private List<String> dataSetArns = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String themeArn;
        private List<Sheet> sheets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardVersion model) {
            this.createdTime(model.createdTime);
            this.errors(model.errors);
            this.versionNumber(model.versionNumber);
            this.status(model.status);
            this.arn(model.arn);
            this.sourceEntityArn(model.sourceEntityArn);
            this.dataSetArns(model.dataSetArns);
            this.description(model.description);
            this.themeArn(model.themeArn);
            this.sheets(model.sheets);
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final List<DashboardError.Builder> getErrors() {
            List<DashboardError.Builder> result = DashboardErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<DashboardError.BuilderImpl> errors) {
            this.errors = DashboardErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<DashboardError> errors) {
            this.errors = DashboardErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(DashboardError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<DashboardError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (DashboardError)((DashboardError.Builder)DashboardError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSourceEntityArn() {
            return this.sourceEntityArn;
        }

        public final void setSourceEntityArn(String sourceEntityArn) {
            this.sourceEntityArn = sourceEntityArn;
        }

        @Override
        public final Builder sourceEntityArn(String sourceEntityArn) {
            this.sourceEntityArn = sourceEntityArn;
            return this;
        }

        public final Collection<String> getDataSetArns() {
            if (this.dataSetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataSetArns;
        }

        public final void setDataSetArns(Collection<String> dataSetArns) {
            this.dataSetArns = DataSetArnsListCopier.copy(dataSetArns);
        }

        @Override
        public final Builder dataSetArns(Collection<String> dataSetArns) {
            this.dataSetArns = DataSetArnsListCopier.copy(dataSetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetArns(String ... dataSetArns) {
            this.dataSetArns(Arrays.asList(dataSetArns));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getThemeArn() {
            return this.themeArn;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        @Override
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        public final List<Sheet.Builder> getSheets() {
            List<Sheet.Builder> result = SheetListCopier.copyToBuilder(this.sheets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSheets(Collection<Sheet.BuilderImpl> sheets) {
            this.sheets = SheetListCopier.copyFromBuilder(sheets);
        }

        @Override
        public final Builder sheets(Collection<Sheet> sheets) {
            this.sheets = SheetListCopier.copy(sheets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheets(Sheet ... sheets) {
            this.sheets(Arrays.asList(sheets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheets(Consumer<Sheet.Builder> ... sheets) {
            this.sheets(Stream.of(sheets).map(c -> (Sheet)((Sheet.Builder)Sheet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DashboardVersion build() {
            return new DashboardVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashboardVersion> {
        public Builder createdTime(Instant var1);

        public Builder errors(Collection<DashboardError> var1);

        public Builder errors(DashboardError ... var1);

        public Builder errors(Consumer<DashboardError.Builder> ... var1);

        public Builder versionNumber(Long var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder arn(String var1);

        public Builder sourceEntityArn(String var1);

        public Builder dataSetArns(Collection<String> var1);

        public Builder dataSetArns(String ... var1);

        public Builder description(String var1);

        public Builder themeArn(String var1);

        public Builder sheets(Collection<Sheet> var1);

        public Builder sheets(Sheet ... var1);

        public Builder sheets(Consumer<Sheet.Builder> ... var1);
    }
}

