/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.LineChartLineStyleSettings;
import software.amazon.awssdk.services.quicksight.model.LineChartMarkerStyleSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineChartSeriesSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineChartSeriesSettings> {
    private static final SdkField<LineChartLineStyleSettings> LINE_STYLE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LineStyleSettings").getter(LineChartSeriesSettings.getter(LineChartSeriesSettings::lineStyleSettings)).setter(LineChartSeriesSettings.setter(Builder::lineStyleSettings)).constructor(LineChartLineStyleSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineStyleSettings").build()}).build();
    private static final SdkField<LineChartMarkerStyleSettings> MARKER_STYLE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MarkerStyleSettings").getter(LineChartSeriesSettings.getter(LineChartSeriesSettings::markerStyleSettings)).setter(LineChartSeriesSettings.setter(Builder::markerStyleSettings)).constructor(LineChartMarkerStyleSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarkerStyleSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_STYLE_SETTINGS_FIELD, MARKER_STYLE_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LineChartSeriesSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LineChartLineStyleSettings lineStyleSettings;
    private final LineChartMarkerStyleSettings markerStyleSettings;

    private LineChartSeriesSettings(BuilderImpl builder) {
        this.lineStyleSettings = builder.lineStyleSettings;
        this.markerStyleSettings = builder.markerStyleSettings;
    }

    public final LineChartLineStyleSettings lineStyleSettings() {
        return this.lineStyleSettings;
    }

    public final LineChartMarkerStyleSettings markerStyleSettings() {
        return this.markerStyleSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lineStyleSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.markerStyleSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineChartSeriesSettings)) {
            return false;
        }
        LineChartSeriesSettings other = (LineChartSeriesSettings)obj;
        return Objects.equals(this.lineStyleSettings(), other.lineStyleSettings()) && Objects.equals(this.markerStyleSettings(), other.markerStyleSettings());
    }

    public final String toString() {
        return ToString.builder((String)"LineChartSeriesSettings").add("LineStyleSettings", (Object)this.lineStyleSettings()).add("MarkerStyleSettings", (Object)this.markerStyleSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LineStyleSettings": {
                return Optional.ofNullable(clazz.cast(this.lineStyleSettings()));
            }
            case "MarkerStyleSettings": {
                return Optional.ofNullable(clazz.cast(this.markerStyleSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LineStyleSettings", LINE_STYLE_SETTINGS_FIELD);
        map.put("MarkerStyleSettings", MARKER_STYLE_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineChartSeriesSettings, T> g) {
        return obj -> g.apply((LineChartSeriesSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LineChartLineStyleSettings lineStyleSettings;
        private LineChartMarkerStyleSettings markerStyleSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(LineChartSeriesSettings model) {
            this.lineStyleSettings(model.lineStyleSettings);
            this.markerStyleSettings(model.markerStyleSettings);
        }

        public final LineChartLineStyleSettings.Builder getLineStyleSettings() {
            return this.lineStyleSettings != null ? this.lineStyleSettings.toBuilder() : null;
        }

        public final void setLineStyleSettings(LineChartLineStyleSettings.BuilderImpl lineStyleSettings) {
            this.lineStyleSettings = lineStyleSettings != null ? lineStyleSettings.build() : null;
        }

        @Override
        public final Builder lineStyleSettings(LineChartLineStyleSettings lineStyleSettings) {
            this.lineStyleSettings = lineStyleSettings;
            return this;
        }

        public final LineChartMarkerStyleSettings.Builder getMarkerStyleSettings() {
            return this.markerStyleSettings != null ? this.markerStyleSettings.toBuilder() : null;
        }

        public final void setMarkerStyleSettings(LineChartMarkerStyleSettings.BuilderImpl markerStyleSettings) {
            this.markerStyleSettings = markerStyleSettings != null ? markerStyleSettings.build() : null;
        }

        @Override
        public final Builder markerStyleSettings(LineChartMarkerStyleSettings markerStyleSettings) {
            this.markerStyleSettings = markerStyleSettings;
            return this;
        }

        public LineChartSeriesSettings build() {
            return new LineChartSeriesSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineChartSeriesSettings> {
        public Builder lineStyleSettings(LineChartLineStyleSettings var1);

        default public Builder lineStyleSettings(Consumer<LineChartLineStyleSettings.Builder> lineStyleSettings) {
            return this.lineStyleSettings((LineChartLineStyleSettings)((LineChartLineStyleSettings.Builder)LineChartLineStyleSettings.builder().applyMutation(lineStyleSettings)).build());
        }

        public Builder markerStyleSettings(LineChartMarkerStyleSettings var1);

        default public Builder markerStyleSettings(Consumer<LineChartMarkerStyleSettings.Builder> markerStyleSettings) {
            return this.markerStyleSettings((LineChartMarkerStyleSettings)((LineChartMarkerStyleSettings.Builder)LineChartMarkerStyleSettings.builder().applyMutation(markerStyleSettings)).build());
        }
    }
}

