/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataSetStringListFilterOperator;
import software.amazon.awssdk.services.quicksight.model.DataSetStringListFilterValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSetStringListFilterCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSetStringListFilterCondition> {
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(DataSetStringListFilterCondition.getter(DataSetStringListFilterCondition::operatorAsString)).setter(DataSetStringListFilterCondition.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final SdkField<DataSetStringListFilterValue> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Values").getter(DataSetStringListFilterCondition.getter(DataSetStringListFilterCondition::values)).setter(DataSetStringListFilterCondition.setter(Builder::values)).constructor(DataSetStringListFilterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATOR_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSetStringListFilterCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String operator;
    private final DataSetStringListFilterValue values;

    private DataSetStringListFilterCondition(BuilderImpl builder) {
        this.operator = builder.operator;
        this.values = builder.values;
    }

    public final DataSetStringListFilterOperator operator() {
        return DataSetStringListFilterOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final DataSetStringListFilterValue values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetStringListFilterCondition)) {
            return false;
        }
        DataSetStringListFilterCondition other = (DataSetStringListFilterCondition)obj;
        return Objects.equals(this.operatorAsString(), other.operatorAsString()) && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"DataSetStringListFilterCondition").add("Operator", (Object)this.operatorAsString()).add("Values", (Object)this.values()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Operator", OPERATOR_FIELD);
        map.put("Values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetStringListFilterCondition, T> g) {
        return obj -> g.apply((DataSetStringListFilterCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operator;
        private DataSetStringListFilterValue values;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetStringListFilterCondition model) {
            this.operator(model.operator);
            this.values(model.values);
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(DataSetStringListFilterOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final DataSetStringListFilterValue.Builder getValues() {
            return this.values != null ? this.values.toBuilder() : null;
        }

        public final void setValues(DataSetStringListFilterValue.BuilderImpl values) {
            this.values = values != null ? values.build() : null;
        }

        @Override
        public final Builder values(DataSetStringListFilterValue values) {
            this.values = values;
            return this;
        }

        public DataSetStringListFilterCondition build() {
            return new DataSetStringListFilterCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSetStringListFilterCondition> {
        public Builder operator(String var1);

        public Builder operator(DataSetStringListFilterOperator var1);

        public Builder values(DataSetStringListFilterValue var1);

        default public Builder values(Consumer<DataSetStringListFilterValue.Builder> values) {
            return this.values((DataSetStringListFilterValue)((DataSetStringListFilterValue.Builder)DataSetStringListFilterValue.builder().applyMutation(values)).build());
        }
    }
}

