/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRefreshScheduleRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, DeleteRefreshScheduleRequest> {
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(DeleteRefreshScheduleRequest.getter(DeleteRefreshScheduleRequest::dataSetId)).setter(DeleteRefreshScheduleRequest.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSetId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(DeleteRefreshScheduleRequest.getter(DeleteRefreshScheduleRequest::awsAccountId)).setter(DeleteRefreshScheduleRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> SCHEDULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleId").getter(DeleteRefreshScheduleRequest.getter(DeleteRefreshScheduleRequest::scheduleId)).setter(DeleteRefreshScheduleRequest.setter(Builder::scheduleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ScheduleId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ID_FIELD, AWS_ACCOUNT_ID_FIELD, SCHEDULE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteRefreshScheduleRequest.memberNameToFieldInitializer();
    private final String dataSetId;
    private final String awsAccountId;
    private final String scheduleId;

    private DeleteRefreshScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.dataSetId = builder.dataSetId;
        this.awsAccountId = builder.awsAccountId;
        this.scheduleId = builder.scheduleId;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String scheduleId() {
        return this.scheduleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRefreshScheduleRequest)) {
            return false;
        }
        DeleteRefreshScheduleRequest other = (DeleteRefreshScheduleRequest)((Object)obj);
        return Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.scheduleId(), other.scheduleId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRefreshScheduleRequest").add("DataSetId", (Object)this.dataSetId()).add("AwsAccountId", (Object)this.awsAccountId()).add("ScheduleId", (Object)this.scheduleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "ScheduleId": {
                return Optional.ofNullable(clazz.cast(this.scheduleId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DataSetId", DATA_SET_ID_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("ScheduleId", SCHEDULE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRefreshScheduleRequest, T> g) {
        return obj -> g.apply((DeleteRefreshScheduleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String dataSetId;
        private String awsAccountId;
        private String scheduleId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRefreshScheduleRequest model) {
            super(model);
            this.dataSetId(model.dataSetId);
            this.awsAccountId(model.awsAccountId);
            this.scheduleId(model.scheduleId);
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getScheduleId() {
            return this.scheduleId;
        }

        public final void setScheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
        }

        @Override
        public final Builder scheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRefreshScheduleRequest build() {
            return new DeleteRefreshScheduleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRefreshScheduleRequest> {
        public Builder dataSetId(String var1);

        public Builder awsAccountId(String var1);

        public Builder scheduleId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

